/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;

public final class ColumnCountMessage
implements ServerMessage {
    private final int totalColumns;

    private ColumnCountMessage(int totalColumns) {
        AssertUtils.require(totalColumns > 0, "totalColumns must be a positive integer");
        this.totalColumns = totalColumns;
    }

    public int getTotalColumns() {
        return this.totalColumns;
    }

    static ColumnCountMessage decode(ByteBuf buf) {
        return new ColumnCountMessage(Math.toIntExact(VarIntUtils.readVarInt(buf)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnCountMessage)) {
            return false;
        }
        ColumnCountMessage that = (ColumnCountMessage)o;
        return this.totalColumns == that.totalColumns;
    }

    public int hashCode() {
        return this.totalColumns;
    }

    public String toString() {
        return String.format("ColumnCountMessage{totalColumns=%d}", this.totalColumns);
    }
}

