/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.ConnectionContext;
import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.message.server.ServerMessage;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class DefinitionMetadataMessage
implements ServerMessage {
    @Nullable
    private final String database;
    private final String table;
    @Nullable
    private final String originTable;
    private final String column;
    @Nullable
    private final String originColumn;
    private final int collationId;
    private final long size;
    private final short type;
    private final short definitions;
    private final short decimals;

    private DefinitionMetadataMessage(@Nullable String database, String table, @Nullable String originTable, String column, @Nullable String originColumn, int collationId, long size, short type, short definitions, short decimals) {
        AssertUtils.require(size >= 0L, "size must not be a negative integer");
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.database = database;
        this.table = AssertUtils.requireNonNull(table, "table must not be null");
        this.originTable = originTable;
        this.column = AssertUtils.requireNonNull(column, "column must not be null");
        this.originColumn = originColumn;
        this.collationId = collationId;
        this.size = size;
        this.type = type;
        this.definitions = definitions;
        this.decimals = decimals;
    }

    public String getColumn() {
        return this.column;
    }

    public int getCollationId() {
        return this.collationId;
    }

    public long getSize() {
        return this.size;
    }

    public short getType() {
        return this.type;
    }

    public short getDefinitions() {
        return this.definitions;
    }

    public short getDecimals() {
        return this.decimals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefinitionMetadataMessage)) {
            return false;
        }
        DefinitionMetadataMessage that = (DefinitionMetadataMessage)o;
        return this.collationId == that.collationId && this.size == that.size && this.type == that.type && this.definitions == that.definitions && this.decimals == that.decimals && Objects.equals(this.database, that.database) && this.table.equals(that.table) && Objects.equals(this.originTable, that.originTable) && this.column.equals(that.column) && Objects.equals(this.originColumn, that.originColumn);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table, this.originTable, this.column, this.originColumn, this.collationId, this.size, this.type, this.definitions, this.decimals);
    }

    public String toString() {
        return String.format("DefinitionMetadataMessage{database='%s', table='%s' (origin:'%s'), column='%s' (origin:'%s'), collationId=%d, size=%d, type=%d, definitions=%x, decimals=%d}", this.database, this.table, this.originTable, this.column, this.originColumn, this.collationId, this.size, this.type, this.definitions, this.decimals);
    }

    static DefinitionMetadataMessage decode(ByteBuf buf, ConnectionContext context) {
        if ((context.getCapabilities() & 0x200) == 0) {
            return DefinitionMetadataMessage.decode320(buf, context);
        }
        return DefinitionMetadataMessage.decode41(buf, context);
    }

    private static DefinitionMetadataMessage decode320(ByteBuf buf, ConnectionContext context) {
        CharCollation collation = context.getClientCollation();
        Charset charset = collation.getCharset();
        String table = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String column = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        buf.skipBytes(1);
        int size = buf.readUnsignedMediumLE();
        buf.skipBytes(1);
        short type = buf.readUnsignedByte();
        buf.skipBytes(1);
        short definitions = buf.readShortLE();
        short decimals = buf.readUnsignedByte();
        return new DefinitionMetadataMessage(null, table, null, column, null, collation.getId(), size, type, definitions, decimals);
    }

    private static DefinitionMetadataMessage decode41(ByteBuf buf, ConnectionContext context) {
        buf.skipBytes(4);
        CharCollation collation = context.getClientCollation();
        Charset charset = collation.getCharset();
        String database = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String table = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String originTable = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String column = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        String originColumn = DefinitionMetadataMessage.readVarIntSizedString(buf, charset);
        VarIntUtils.readVarInt(buf);
        int collationId = buf.readUnsignedShortLE();
        long size = buf.readUnsignedIntLE();
        short type = buf.readUnsignedByte();
        short definitions = buf.readShortLE();
        if (245 == type && collationId == CharCollation.BINARY_ID) {
            collationId = collation.getId();
        }
        if ((definitions & 0x800) != 0) {
            type = 248;
        } else if ((definitions & 0x100) != 0) {
            type = 247;
        }
        return new DefinitionMetadataMessage(database, table, originTable, column, originColumn, collationId, size, type, definitions, buf.readUnsignedByte());
    }

    private static String readVarIntSizedString(ByteBuf buf, Charset charset) {
        int bytes = (int)VarIntUtils.readVarInt(buf);
        if (bytes == 0) {
            return "";
        }
        String result = buf.toString(buf.readerIndex(), bytes, charset);
        buf.skipBytes(bytes);
        return result;
    }
}

