/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.message.server.HandshakeHeader;
import dev.miku.r2dbc.mysql.message.server.HandshakeRequest;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import dev.miku.r2dbc.mysql.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;

final class HandshakeV9Request
implements HandshakeRequest {
    private final HandshakeHeader header;
    private final byte[] salt;

    private HandshakeV9Request(HandshakeHeader header, byte[] salt) {
        this.header = AssertUtils.requireNonNull(header, "header must not be null");
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
    }

    @Override
    public HandshakeHeader getHeader() {
        return this.header;
    }

    @Override
    public int getServerCapabilities() {
        return 0;
    }

    @Override
    public String getAuthType() {
        return "mysql_old_password";
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeV9Request)) {
            return false;
        }
        HandshakeV9Request that = (HandshakeV9Request)o;
        if (!this.header.equals(that.header)) {
            return false;
        }
        return Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + Arrays.hashCode(this.salt);
        return result;
    }

    public String toString() {
        return String.format("HandshakeV9Request{header=%s, salt=REDACTED}", this.header);
    }

    static HandshakeV9Request decodeV9(ByteBuf buf, HandshakeHeader header) {
        int bytes = buf.readableBytes();
        if (bytes <= 0) {
            return new HandshakeV9Request(header, InternalArrays.EMPTY_BYTES);
        }
        byte[] salt = buf.getByte(buf.writerIndex() - 1) == 0 ? ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)(bytes - 1)) : ByteBufUtil.getBytes((ByteBuf)buf);
        return new HandshakeV9Request(header, salt);
    }
}

