/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbKeyPair;
import dadb.AdbMessage;
import dadb.AdbMessageQueue;
import dadb.AdbReader;
import dadb.AdbStream;
import dadb.AdbWriter;
import dadb.ConnectionString;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\fH\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldadb/AdbConnection;", "Ljava/lang/AutoCloseable;", "adbReader", "Ldadb/AdbReader;", "adbWriter", "Ldadb/AdbWriter;", "closeable", "Ljava/io/Closeable;", "supportedFeatures", "", "", "version", "", "maxPayloadSize", "(Ldadb/AdbReader;Ldadb/AdbWriter;Ljava/io/Closeable;Ljava/util/Set;II)V", "messageQueue", "Ldadb/AdbMessageQueue;", "random", "Ljava/util/Random;", "close", "", "ensureEmpty", "ensureEmpty$dadb", "newId", "open", "Ldadb/AdbStream;", "destination", "supportsFeature", "", "feature", "Companion", "dadb"})
public final class AdbConnection
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdbWriter adbWriter;
    @Nullable
    private final Closeable closeable;
    @NotNull
    private final Set<String> supportedFeatures;
    private final int version;
    private final int maxPayloadSize;
    @NotNull
    private final Random random;
    @NotNull
    private final AdbMessageQueue messageQueue;

    public AdbConnection(@NotNull AdbReader adbReader, @NotNull AdbWriter adbWriter, @Nullable Closeable closeable, @NotNull Set<String> supportedFeatures, int version, int maxPayloadSize) {
        Intrinsics.checkNotNullParameter((Object)adbReader, (String)"adbReader");
        Intrinsics.checkNotNullParameter((Object)adbWriter, (String)"adbWriter");
        Intrinsics.checkNotNullParameter(supportedFeatures, (String)"supportedFeatures");
        this.adbWriter = adbWriter;
        this.closeable = closeable;
        this.supportedFeatures = supportedFeatures;
        this.version = version;
        this.maxPayloadSize = maxPayloadSize;
        this.random = new Random();
        this.messageQueue = new AdbMessageQueue(adbReader);
    }

    @NotNull
    public final AdbStream open(@NotNull String destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int localId = this.newId();
        this.messageQueue.startListening(localId);
        try {
            this.adbWriter.writeOpen(localId, destination);
            AdbMessage message = (AdbMessage)this.messageQueue.take(localId, 1497451343);
            int remoteId = message.getArg0();
            return new AdbStream(this.messageQueue, this.adbWriter, this.maxPayloadSize, localId, remoteId);
        }
        catch (Throwable e) {
            this.messageQueue.stopListening(localId);
            throw e;
        }
    }

    public final boolean supportsFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.supportedFeatures.contains(feature);
    }

    private final int newId() {
        return this.random.nextInt();
    }

    public final void ensureEmpty$dadb() {
        this.messageQueue.ensureEmpty();
    }

    @Override
    public void close() {
        try {
            this.messageQueue.close();
            this.adbWriter.close();
            Closeable closeable = this.closeable;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Ldadb/AdbConnection$Companion;", "", "()V", "connect", "Ldadb/AdbConnection;", "adbReader", "Ldadb/AdbReader;", "adbWriter", "Ldadb/AdbWriter;", "keyPair", "Ldadb/AdbKeyPair;", "closeable", "Ljava/io/Closeable;", "socket", "Ljava/net/Socket;", "source", "Lokio/Source;", "sink", "Lokio/Sink;", "parseConnectionString", "Ldadb/ConnectionString;", "connectionString", "", "dadb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdbConnection connect(@NotNull Socket socket, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Source source2 = Okio.source((Socket)socket);
            Sink sink2 = Okio.sink((Socket)socket);
            return this.connect(source2, sink2, keyPair, (Closeable)socket);
        }

        public static /* synthetic */ AdbConnection connect$default(Companion companion, Socket socket, AdbKeyPair adbKeyPair, int n, Object object) {
            if ((n & 2) != 0) {
                adbKeyPair = null;
            }
            return companion.connect(socket, adbKeyPair);
        }

        private final AdbConnection connect(Source source2, Sink sink2, AdbKeyPair keyPair, Closeable closeable) {
            AdbReader adbReader = new AdbReader(source2);
            AdbWriter adbWriter = new AdbWriter(sink2);
            try {
                return this.connect(adbReader, adbWriter, keyPair, closeable);
            }
            catch (Throwable t) {
                adbReader.close();
                adbWriter.close();
                throw t;
            }
        }

        static /* synthetic */ AdbConnection connect$default(Companion companion, Source source2, Sink sink2, AdbKeyPair adbKeyPair, Closeable closeable, int n, Object object) {
            if ((n & 4) != 0) {
                adbKeyPair = null;
            }
            if ((n & 8) != 0) {
                closeable = null;
            }
            return companion.connect(source2, sink2, adbKeyPair, closeable);
        }

        private final AdbConnection connect(AdbReader adbReader, AdbWriter adbWriter, AdbKeyPair keyPair, Closeable closeable) {
            boolean bl4;
            adbWriter.writeConnect();
            AdbMessage message = null;
            message = adbReader.readMessage();
            if (message.getCommand() == 1213486401) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (keyPair == null) {
                    boolean bl4 = false;
                    String string = "Authentication required but no KeyPair provided";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                bl2 = message.getArg0() == 1;
                bl3 = false;
                bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String bl4 = Intrinsics.stringPlus((String)"Unsupported auth type: ", (Object)message);
                    throw (Throwable)new IllegalStateException(bl4.toString());
                }
                byte[] signature = keyPair.signPayload$dadb(message);
                adbWriter.writeAuth(2, signature);
                message = adbReader.readMessage();
                if (message.getCommand() == 1213486401) {
                    adbWriter.writeAuth(3, keyPair.getPublicKeyBytes$dadb());
                    message = adbReader.readMessage();
                }
            }
            if (message.getCommand() != 1314410051) {
                throw new IOException(Intrinsics.stringPlus((String)"Connection failed: ", (Object)message));
            }
            byte[] byArray = message.getPayload();
            bl4 = false;
            ConnectionString connectionString = this.parseConnectionString(new String(byArray, Charsets.UTF_8));
            int version = message.getArg0();
            int maxPayloadSize = message.getArg1();
            return new AdbConnection(adbReader, adbWriter, closeable, connectionString.getFeatures(), version, maxPayloadSize);
        }

        /*
         * WARNING - void declaration
         */
        private final ConnectionString parseConnectionString(String connectionString) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Iterable $this$mapTo$iv$iv;
            String[] stringArray = new String[]{";"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)connectionString, (String)"device::", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                List list = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                collection.add(list);
            }
            Object $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                List it = (List)element$iv$iv;
                boolean bl2 = false;
                if ((it.size() != 2 ? null : TuplesKt.to(it.get(0), it.get(1))) == null) continue;
                pair = pair;
                boolean bl3 = false;
                boolean bl4 = false;
                Pair it$iv$iv = pair;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map keyValues = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            $this$mapNotNull$iv = keyValues;
            String[] stringArray3 = "features";
            boolean bl = false;
            Object object2 = $this$mapNotNull$iv;
            boolean bl6 = false;
            if (!object2.containsKey(stringArray3)) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to parse features from connection string: ", (Object)connectionString));
            }
            stringArray3 = new String[]{","};
            Set features = CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)((CharSequence)MapsKt.getValue((Map)keyValues, (Object)"features")), (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
            return new ConnectionString(features);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

