/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbMessage;
import dadb.PKCS8;
import java.io.File;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ldadb/AdbKeyPair;", "", "privateKey", "Ljava/security/PrivateKey;", "publicKeyBytes", "", "(Ljava/security/PrivateKey;[B)V", "getPublicKeyBytes$dadb", "()[B", "signPayload", "message", "Ldadb/AdbMessage;", "signPayload$dadb", "Companion", "dadb"})
public final class AdbKeyPair {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final byte[] publicKeyBytes;
    @NotNull
    private static final byte[] SIGNATURE_PADDING;

    public AdbKeyPair(@NotNull PrivateKey privateKey, @NotNull byte[] publicKeyBytes) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKeyBytes, (String)"publicKeyBytes");
        this.privateKey = privateKey;
        this.publicKeyBytes = publicKeyBytes;
    }

    @NotNull
    public final byte[] getPublicKeyBytes$dadb() {
        return this.publicKeyBytes;
    }

    @NotNull
    public final byte[] signPayload$dadb(@NotNull AdbMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
        cipher.init(1, this.privateKey);
        cipher.update(SIGNATURE_PADDING);
        byte[] byArray = cipher.doFinal(message.getPayload(), 0, message.getPayloadLength());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(message.p\u20260, message.payloadLength)");
        return byArray;
    }

    @JvmStatic
    @Nullable
    public static final AdbKeyPair readDefault() {
        return Companion.readDefault();
    }

    @JvmStatic
    @Nullable
    public static final AdbKeyPair read(@NotNull File privateKeyFile, @NotNull File publicKeyFile) {
        return Companion.read(privateKeyFile, publicKeyFile);
    }

    static {
        byte[] byArray = new byte[]{0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        boolean bl = false;
        byte[] byArray2 = byArray;
        boolean bl2 = false;
        byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, size)");
        SIGNATURE_PADDING = byArray3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldadb/AdbKeyPair$Companion;", "", "()V", "SIGNATURE_PADDING", "", "read", "Ldadb/AdbKeyPair;", "privateKeyFile", "Ljava/io/File;", "publicKeyFile", "readAdbPublicKey", "file", "readDefault", "dadb"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AdbKeyPair readDefault() {
            File privateKeyFile = new File(System.getenv("HOME"), ".android/adbkey");
            File publicKeyFile = new File(System.getenv("HOME"), ".android/adbkey.pub");
            return this.read(privateKeyFile, publicKeyFile);
        }

        @JvmStatic
        @Nullable
        public final AdbKeyPair read(@NotNull File privateKeyFile, @NotNull File publicKeyFile) {
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            Intrinsics.checkNotNullParameter((Object)publicKeyFile, (String)"publicKeyFile");
            if (!privateKeyFile.exists() || !publicKeyFile.exists()) {
                return null;
            }
            PrivateKey privateKey = PKCS8.INSTANCE.parse(FilesKt.readBytes((File)privateKeyFile));
            byte[] publicKeyBytes = this.readAdbPublicKey(publicKeyFile);
            return new AdbKeyPair(privateKey, publicKeyBytes);
        }

        private final byte[] readAdbPublicKey(File file) {
            byte[] bytes;
            byte[] byArray = bytes = FilesKt.readBytes((File)file);
            int n = bytes.length + 1;
            boolean bl = false;
            byte[] byArray2 = Arrays.copyOf(byArray, n);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            byte[] publicKeyBytes = byArray2;
            publicKeyBytes[bytes.length] = 0;
            return publicKeyBytes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

