/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbShellPacket;
import dadb.AdbShellResponse;
import dadb.AdbStream;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldadb/AdbShellStream;", "Ljava/lang/AutoCloseable;", "stream", "Ldadb/AdbStream;", "(Ldadb/AdbStream;)V", "checkId", "", "id", "checkLength", "length", "close", "", "read", "Ldadb/AdbShellPacket;", "readAll", "Ldadb/AdbShellResponse;", "write", "payload", "", "string", "", "dadb"})
public final class AdbShellStream
implements AutoCloseable {
    @NotNull
    private final AdbStream stream;

    public AdbShellStream(@NotNull AdbStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
    }

    @NotNull
    public final AdbShellResponse readAll() throws IOException {
        int id;
        StringBuilder output = new StringBuilder();
        StringBuilder errorOutput = new StringBuilder();
        block4: while (true) {
            AdbShellPacket packet = this.read();
            id = packet.getId();
            switch (id) {
                case 3: {
                    byte exitCode = packet.getPayload()[0];
                    Object object = output.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"output.toString()");
                    Object object2 = object;
                    object = errorOutput.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"errorOutput.toString()");
                    return new AdbShellResponse((String)object2, (String)object, exitCode);
                }
                case 1: 
                case 2: {
                    StringBuilder sb = id == 1 ? output : errorOutput;
                    Object object = packet.getPayload();
                    boolean bl = false;
                    sb.append(new String((byte[])object, Charsets.UTF_8));
                    continue block4;
                }
            }
            break;
        }
        throw new IllegalStateException(Intrinsics.stringPlus((String)"Invalid shell packet id: ", (Object)id));
    }

    @NotNull
    public final AdbShellPacket read() throws IOException {
        BufferedSource bufferedSource = this.stream.getSource();
        boolean bl = false;
        boolean bl2 = false;
        BufferedSource $this$read_u24lambda_u2d0 = bufferedSource;
        boolean bl3 = false;
        int id = this.checkId($this$read_u24lambda_u2d0.readByte());
        int length = this.checkLength(id, $this$read_u24lambda_u2d0.readIntLe());
        byte[] payload = $this$read_u24lambda_u2d0.readByteArray((long)length);
        return new AdbShellPacket(id, payload);
    }

    public final void write(@NotNull String string) throws IOException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.write(0, byArray);
    }

    public final void write(int id, @Nullable byte[] payload) throws IOException {
        int n;
        BufferedSink bufferedSink = this.stream.getSink();
        boolean bl = false;
        boolean bl2 = false;
        BufferedSink $this$write_u24lambda_u2d1 = bufferedSink;
        boolean bl3 = false;
        $this$write_u24lambda_u2d1.writeByte(id);
        byte[] byArray = payload;
        $this$write_u24lambda_u2d1.writeIntLe(byArray == null ? 0 : (n = byArray.length));
        if (payload != null) {
            $this$write_u24lambda_u2d1.write(payload);
        }
        $this$write_u24lambda_u2d1.flush();
    }

    public static /* synthetic */ void write$default(AdbShellStream adbShellStream, int n, byte[] byArray, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        adbShellStream.write(n, byArray);
    }

    @Override
    public void close() {
        this.stream.close();
    }

    private final int checkId(int id) {
        boolean bl = id == 1 || id == 2 || id == 3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid shell packet id: ", (Object)id);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return id;
    }

    private final int checkLength(int id, int length) {
        boolean bl = length >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Shell packet length must be >= 0: ", (Object)length);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = id != 3 || length == 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = Intrinsics.stringPlus((String)"Shell exit packet does not have payload length == 1: ", (Object)length);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return length;
    }
}

