/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbStream;
import dadb.Packet;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldadb/AdbSyncStream;", "Ljava/lang/AutoCloseable;", "stream", "Ldadb/AdbStream;", "(Ldadb/AdbStream;)V", "buffer", "Lokio/Buffer;", "close", "", "readPacket", "Ldadb/Packet;", "recv", "sink", "Lokio/Sink;", "remotePath", "", "send", "source", "Lokio/Source;", "mode", "", "lastModifiedMs", "", "writePacket", "id", "arg", "dadb"})
public final class AdbSyncStream
implements AutoCloseable {
    @NotNull
    private final AdbStream stream;
    @NotNull
    private final Buffer buffer;

    public AdbSyncStream(@NotNull AdbStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buffer = new Buffer();
    }

    public final void send(@NotNull Source source2, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
        long read;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String remote = remotePath + ',' + mode;
        this.writePacket("SEND", remote.length());
        BufferedSink bufferedSink = this.stream.getSink();
        boolean bl = false;
        boolean bl2 = false;
        BufferedSink $this$send_u24lambda_u2d0 = bufferedSink;
        boolean bl3 = false;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        $this$send_u24lambda_u2d0.writeString(remote, charset);
        $this$send_u24lambda_u2d0.flush();
        this.buffer.clear();
        while ((read = source2.read(this.buffer, 64000L)) != -1L) {
            this.writePacket("DATA", (int)read);
            long sent = this.stream.getSink().writeAll((Source)this.buffer);
            boolean bl4 = read == sent;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (bl4) continue;
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.writePacket("DONE", (int)(lastModifiedMs / (long)1000));
        this.stream.getSink().flush();
        Packet packet = this.readPacket();
        if (!Intrinsics.areEqual((Object)packet.getId(), (Object)"OKAY")) {
            throw new IOException(Intrinsics.stringPlus((String)"Unexpected sync packet id: ", (Object)packet.getId()));
        }
    }

    public final void recv(@NotNull Sink sink2, @NotNull String remotePath) throws IOException {
        Packet packet;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        this.writePacket("RECV", remotePath.length());
        BufferedSink bufferedSink = this.stream.getSink();
        boolean bl = false;
        boolean bl2 = false;
        BufferedSink $this$recv_u24lambda_u2d1 = bufferedSink;
        boolean bl3 = false;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        $this$recv_u24lambda_u2d1.writeString(remotePath, charset);
        $this$recv_u24lambda_u2d1.flush();
        this.buffer.clear();
        while (!Intrinsics.areEqual((Object)(packet = this.readPacket()).getId(), (Object)"DONE")) {
            if (Intrinsics.areEqual((Object)packet.getId(), (Object)"FAIL")) {
                BufferedSource bufferedSource = this.stream.getSource();
                long l = packet.getArg();
                Charset charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                String message = bufferedSource.readString(l, charset2);
                throw new IOException(Intrinsics.stringPlus((String)"Sync failed: ", (Object)message));
            }
            if (!Intrinsics.areEqual((Object)packet.getId(), (Object)"DATA")) {
                throw new IOException(Intrinsics.stringPlus((String)"Unexpected sync packet id: ", (Object)packet.getId()));
            }
            int chunkSize = packet.getArg();
            this.stream.getSource().readFully(this.buffer, (long)chunkSize);
            this.buffer.readAll(sink2);
        }
        sink2.flush();
    }

    private final void writePacket(String id, int arg) {
        BufferedSink bufferedSink = this.stream.getSink();
        boolean bl = false;
        boolean bl2 = false;
        BufferedSink $this$writePacket_u24lambda_u2d2 = bufferedSink;
        boolean bl3 = false;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        $this$writePacket_u24lambda_u2d2.writeString(id, charset);
        $this$writePacket_u24lambda_u2d2.writeIntLe(arg);
        $this$writePacket_u24lambda_u2d2.flush();
    }

    private final Packet readPacket() {
        BufferedSource bufferedSource = this.stream.getSource();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        String id = bufferedSource.readString(4L, charset);
        int arg = this.stream.getSource().readIntLe();
        return new Packet(id, arg);
    }

    @Override
    public void close() {
        this.writePacket("QUIT", 0);
        this.stream.close();
    }
}

