/*
 * Decompiled with CFR 0.152.
 */
package dadb;

import dadb.AdbKeyPair;
import dadb.AdbShellResponse;
import dadb.AdbShellStream;
import dadb.AdbStream;
import dadb.AdbSyncStream;
import dadb.DadbImpl;
import dadb.forwarding.TcpForwarder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\bf\u0018\u0000 -2\u00020\u0001:\u0001-J!\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H&J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J,\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0006H&J\u0018\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0006H\u0016J\b\u0010,\u001a\u00020\tH\u0016\u00a8\u0006."}, d2={"Ldadb/Dadb;", "Ljava/lang/AutoCloseable;", "abbExec", "Ldadb/AdbStream;", "command", "", "", "([Ljava/lang/String;)Ldadb/AdbStream;", "install", "", "file", "Ljava/io/File;", "options", "(Ljava/io/File;[Ljava/lang/String;)V", "open", "destination", "openShell", "Ldadb/AdbShellStream;", "openSync", "Ldadb/AdbSyncStream;", "pull", "dst", "remotePath", "sink", "Lokio/Sink;", "push", "src", "mode", "", "lastModifiedMs", "", "source", "Lokio/Source;", "root", "shell", "Ldadb/AdbShellResponse;", "supportsFeature", "", "feature", "tcpForward", "hostPort", "targetPort", "uninstall", "packageName", "unroot", "Companion", "dadb"})
public interface Dadb
extends AutoCloseable {
    @NotNull
    public static final Companion Companion = dadb.Dadb$Companion.$$INSTANCE;

    @NotNull
    public AdbStream open(@NotNull String var1) throws IOException;

    public boolean supportsFeature(@NotNull String var1);

    @NotNull
    public AdbShellResponse shell(@NotNull String var1) throws IOException;

    @NotNull
    public AdbShellStream openShell(@NotNull String var1) throws IOException;

    public void push(@NotNull File var1, @NotNull String var2, int var3, long var4) throws IOException;

    public void push(@NotNull Source var1, @NotNull String var2, int var3, long var4) throws IOException;

    public void pull(@NotNull File var1, @NotNull String var2) throws IOException;

    public void pull(@NotNull Sink var1, @NotNull String var2) throws IOException;

    @NotNull
    public AdbSyncStream openSync() throws IOException;

    public void install(@NotNull File var1, String ... var2) throws IOException;

    public void uninstall(@NotNull String var1) throws IOException;

    @NotNull
    public AdbStream abbExec(String ... var1) throws IOException;

    public void root() throws IOException;

    public void unroot() throws IOException;

    @NotNull
    public AutoCloseable tcpForward(int var1, int var2) throws InterruptedException;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair) {
        return Companion.create(host, port, keyPair);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair) {
        return Companion.discover(host, keyPair);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static Dadb create(@NotNull String host, int port) {
        return Companion.create(host, port);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static Dadb discover(@NotNull String host) {
        return Companion.discover(host);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001e\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldadb/Dadb$Companion;", "", "()V", "MAX_EMULATOR_PORT", "", "MIN_EMULATOR_PORT", "create", "Ldadb/Dadb;", "host", "", "port", "keyPair", "Ldadb/AdbKeyPair;", "discover", "readMode", "file", "Ljava/io/File;", "restartAdb", "dadb", "destination", "waitRootOrClose", "", "root", "", "readUntil", "Lokio/Buffer;", "Lokio/BufferedSource;", "endByte", ""})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int MIN_EMULATOR_PORT = 5555;
        private static final int MAX_EMULATOR_PORT = 5683;

        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new DadbImpl(host, port, keyPair);
        }

        public static /* synthetic */ Dadb create$default(Companion companion, String string, int n, AdbKeyPair adbKeyPair, int n2, Object object) {
            if ((n2 & 4) != 0) {
                adbKeyPair = AdbKeyPair.Companion.readDefault();
            }
            return companion.create(string, n, adbKeyPair);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host, @Nullable AdbKeyPair keyPair) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Iterable $this$forEach$iv = (Iterable)new IntRange(5555, 5683);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int port = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Dadb dadb = $$INSTANCE.create(host, port, keyPair);
                try {
                    AdbShellResponse response = dadb.shell("echo success");
                    if (!Intrinsics.areEqual((Object)response.getAllOutput(), (Object)"success\n")) continue;
                    return dadb;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }

        public static /* synthetic */ Dadb discover$default(Companion companion, String string, AdbKeyPair adbKeyPair, int n, Object object) {
            if ((n & 2) != 0) {
                adbKeyPair = AdbKeyPair.Companion.readDefault();
            }
            return companion.discover(string, adbKeyPair);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void waitRootOrClose(Dadb dadb, boolean root) {
            try {
                int propValue;
                AdbShellResponse response;
                do {
                    response = dadb.shell("getprop service.adb.root");
                    int n = propValue = root ? 1 : 0;
                } while (!Intrinsics.areEqual((Object)response.getOutput(), (Object)("" + propValue + '\n')));
                return;
            }
            catch (IOException e) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String restartAdb(Dadb dadb, String destination) {
            AutoCloseable autoCloseable = dadb.open(destination);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbStream stream = (AdbStream)autoCloseable;
                boolean bl3 = false;
                String string = $$INSTANCE.readUntil(stream.getSource(), (byte)10).readString(Charsets.UTF_8);
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final Buffer readUntil(BufferedSource $this$readUntil, byte endByte) {
            byte b;
            Buffer buffer = new Buffer();
            do {
                b = $this$readUntil.readByte();
                buffer.writeByte((int)b);
            } while (b != endByte);
            return buffer;
        }

        private final int readMode(File file) {
            Integer n;
            Object object = Files.getAttribute(file.toPath(), "unix:mode", new LinkOption[0]);
            Integer n2 = n = object instanceof Integer ? (Integer)object : null;
            if (n == null) {
                throw new RuntimeException("Unable to read file mode");
            }
            return n;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Dadb create(@NotNull String host, int port) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.create$default(this, host, port, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final Dadb discover(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return dadb.Dadb$Companion.discover$default(this, host, null, 2, null);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static AdbShellResponse shell(@NotNull Dadb this_, @NotNull String command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            AutoCloseable autoCloseable = this_.openShell(command);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbShellStream stream = (AdbShellStream)autoCloseable;
                boolean bl3 = false;
                AdbShellResponse adbShellResponse = stream.readAll();
                return adbShellResponse;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @NotNull
        public static AdbShellStream openShell(@NotNull Dadb this_, @NotNull String command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            AdbStream stream = this_.open(Intrinsics.stringPlus((String)"shell,v2,raw:", (Object)command));
            return new AdbShellStream(stream);
        }

        public static /* synthetic */ AdbShellStream openShell$default(Dadb dadb, String string, int n, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openShell");
            }
            if ((n & 1) != 0) {
                string = "";
            }
            return dadb.openShell(string);
        }

        public static void push(@NotNull Dadb this_, @NotNull File src, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            this_.push(Okio.source((File)src), remotePath, mode, lastModifiedMs);
        }

        public static /* synthetic */ void push$default(Dadb dadb, File file, String string, int n, long l, int n2, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: push");
            }
            if ((n2 & 4) != 0) {
                n = Companion.readMode(file);
            }
            if ((n2 & 8) != 0) {
                l = file.lastModified();
            }
            dadb.push(file, string, n, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void push(@NotNull Dadb this_, @NotNull Source source2, @NotNull String remotePath, int mode, long lastModifiedMs) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            AutoCloseable autoCloseable = this_.openSync();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbSyncStream stream = (AdbSyncStream)autoCloseable;
                boolean bl3 = false;
                stream.send(source2, remotePath, mode, lastModifiedMs);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static void pull(@NotNull Dadb this_, @NotNull File dst, @NotNull String remotePath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            this_.pull(Okio.sink((File)dst, (boolean)false), remotePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void pull(@NotNull Dadb this_, @NotNull Sink sink2, @NotNull String remotePath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            AutoCloseable autoCloseable = this_.openSync();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                AdbSyncStream stream = (AdbSyncStream)autoCloseable;
                boolean bl3 = false;
                stream.recv(sink2, remotePath);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @NotNull
        public static AdbSyncStream openSync(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            AdbStream stream = this_.open("sync:");
            return new AdbSyncStream(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void install(@NotNull Dadb this_, @NotNull File file, String ... options) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            if (this_.supportsFeature("abb_exec")) {
                Object object = new SpreadBuilder(5);
                object.add((Object)"package");
                object.add((Object)"install");
                object.add((Object)"-S");
                object.add((Object)String.valueOf(file.length()));
                object.addSpread((Object)options);
                object = this_.abbExec((String[])object.toArray((Object[])new String[object.size()]));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    AdbStream stream = (AdbStream)object;
                    boolean bl3 = false;
                    stream.getSink().writeAll(Okio.source((File)file));
                    stream.getSink().flush();
                    String response = stream.getSource().readString(Charsets.UTF_8);
                    if (!StringsKt.startsWith$default((String)response, (String)"Success", (boolean)false, (int)2, null)) {
                        throw new IOException(Intrinsics.stringPlus((String)"Install failed: ", (Object)response));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
            } else {
                String fileName = file.getName();
                String remotePath = Intrinsics.stringPlus((String)"/data/local/tmp/", (Object)fileName);
                DefaultImpls.push$default(this_, file, remotePath, 0, 0L, 12, null);
                this_.shell("pm install " + ArraysKt.joinToString$default((Object[])options, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " \"" + remotePath + '\"');
            }
        }

        public static void uninstall(@NotNull Dadb this_, @NotNull String packageName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            AdbShellResponse response = this_.shell(Intrinsics.stringPlus((String)"cmd package uninstall ", (Object)packageName));
            if (response.getExitCode() != 0) {
                throw new IOException(Intrinsics.stringPlus((String)"Uninstall failed: ", (Object)response.getAllOutput()));
            }
        }

        @NotNull
        public static AdbStream abbExec(@NotNull Dadb this_, String ... command) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (!this_.supportsFeature("abb_exec")) {
                throw new UnsupportedOperationException("abb_exec is not supported on this version of Android");
            }
            String destination = Intrinsics.stringPlus((String)"abb_exec:", (Object)ArraysKt.joinToString$default((Object[])command, (CharSequence)"\u0000", null, null, (int)0, null, null, (int)62, null));
            return this_.open(destination);
        }

        public static void root(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String response = Companion.restartAdb(this_, "root:");
            if (!StringsKt.startsWith$default((String)response, (String)"restarting", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)response, (CharSequence)"already", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to restart adb as root: ", (Object)response));
            }
            Companion.waitRootOrClose(this_, true);
        }

        public static void unroot(@NotNull Dadb this_) throws IOException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String response = Companion.restartAdb(this_, "unroot:");
            if (!StringsKt.startsWith$default((String)response, (String)"restarting", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)response, (CharSequence)"not running as root", (boolean)false, (int)2, null)) {
                throw new IOException(Intrinsics.stringPlus((String)"Failed to restart adb as root: ", (Object)response));
            }
            Companion.waitRootOrClose(this_, false);
        }

        @NotNull
        public static AutoCloseable tcpForward(@NotNull Dadb this_, int hostPort, int targetPort) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            TcpForwarder forwarder = new TcpForwarder(this_, hostPort, targetPort);
            forwarder.start();
            return forwarder;
        }
    }
}

