/*
 * Decompiled with CFR 0.152.
 */
package dadb.forwarding;

import dadb.AdbStream;
import dadb.Dadb;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u0011J&\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Ldadb/forwarding/TcpForwarder;", "Ljava/lang/AutoCloseable;", "dadb", "Ldadb/Dadb;", "hostPort", "", "targetPort", "(Ldadb/Dadb;II)V", "clientExecutor", "Ljava/util/concurrent/ExecutorService;", "server", "Ljava/net/ServerSocket;", "serverThread", "Ljava/lang/Thread;", "state", "Ldadb/forwarding/TcpForwarder$State;", "close", "", "forward", "source", "Lokio/Source;", "sink", "Lokio/BufferedSink;", "handleForwarding", "moveToState", "start", "waitFor", "intervalMs", "timeoutMs", "test", "Lkotlin/Function0;", "", "State"})
public final class TcpForwarder
implements AutoCloseable {
    @NotNull
    private final Dadb dadb;
    private final int hostPort;
    private final int targetPort;
    @NotNull
    private State state;
    @Nullable
    private Thread serverThread;
    @Nullable
    private ServerSocket server;
    @Nullable
    private ExecutorService clientExecutor;

    public TcpForwarder(@NotNull Dadb dadb, int hostPort, int targetPort) {
        Intrinsics.checkNotNullParameter((Object)dadb, (String)"dadb");
        this.dadb = dadb;
        this.hostPort = hostPort;
        this.targetPort = targetPort;
        this.state = State.STOPPED;
    }

    public final void start() {
        boolean bl = this.state == State.STOPPED;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Forwarder is already started at port ", (Object)this.hostPort);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.moveToState(State.STARTING);
        this.clientExecutor = Executors.newCachedThreadPool();
        this.serverThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TcpForwarder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    TcpForwarder.access$handleForwarding(this.this$0);
                }
                catch (SocketException socketException) {
                }
                finally {
                    TcpForwarder.access$moveToState(this.this$0, State.STOPPED);
                }
            }
        }), (int)31, null);
        this.waitFor(10, 5000, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TcpForwarder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return TcpForwarder.access$getState$p(this.this$0) == State.STARTED;
            }
        }));
    }

    private final void handleForwarding() {
        ServerSocket serverRef;
        this.server = serverRef = new ServerSocket(this.hostPort);
        this.moveToState(State.STARTED);
        while (!Thread.interrupted()) {
            Socket client = serverRef.accept();
            ExecutorService executorService = this.clientExecutor;
            if (executorService == null) continue;
            executorService.execute(() -> TcpForwarder.handleForwarding$lambda-1(this, client));
        }
    }

    @Override
    public void close() {
        if (this.state == State.STOPPED || this.state == State.STOPPING) {
            return;
        }
        this.waitFor(10, 5000, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TcpForwarder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return TcpForwarder.access$getState$p(this.this$0) == State.STARTED;
            }
        }));
        this.moveToState(State.STOPPING);
        Object object = this.server;
        if (object != null) {
            ((ServerSocket)object).close();
        }
        this.server = null;
        object = this.serverThread;
        if (object != null) {
            ((Thread)object).interrupt();
        }
        this.serverThread = null;
        object = this.clientExecutor;
        if (object != null) {
            object.shutdown();
        }
        object = this.clientExecutor;
        if (object != null) {
            object.awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.clientExecutor = null;
        this.waitFor(10, 5000, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TcpForwarder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return TcpForwarder.access$getState$p(this.this$0) == State.STOPPED;
            }
        }));
    }

    private final void forward(Source source2, BufferedSink sink2) {
        try {
            while (!Thread.interrupted()) {
                try {
                    if (source2.read(sink2.getBuffer(), 256L) >= 0L) {
                        sink2.flush();
                        continue;
                    }
                    return;
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    private final void moveToState(State state) {
        this.state = state;
    }

    private final void waitFor(int intervalMs, int timeoutMs, Function0<Boolean> test) {
        long start2;
        long lastCheck = start2 = System.currentTimeMillis();
        while (!((Boolean)test.invoke()).booleanValue()) {
            long now = System.currentTimeMillis();
            long timeSinceStart = now - start2;
            long timeSinceLastCheck = now - lastCheck;
            long l = timeoutMs;
            boolean bl = 0L <= l ? l <= timeSinceStart : false;
            if (bl) {
                throw new TimeoutException();
            }
            long sleepTime = (long)intervalMs - timeSinceLastCheck;
            if (sleepTime > 0L) {
                Thread.sleep(sleepTime);
            }
            lastCheck = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleForwarding$lambda-1(TcpForwarder this$0, Socket $client) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdbStream adbStream = this$0.dadb.open(Intrinsics.stringPlus((String)"tcp:", (Object)this$0.targetPort));
        Thread readerThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this$0, $client, adbStream){
            final /* synthetic */ TcpForwarder this$0;
            final /* synthetic */ Socket $client;
            final /* synthetic */ AdbStream $adbStream;
            {
                this.this$0 = $receiver;
                this.$client = $client;
                this.$adbStream = $adbStream;
                super(0);
            }

            public final void invoke() {
                InputStream inputStream = this.$client.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"client.getInputStream()");
                TcpForwarder.access$forward(this.this$0, Okio.source((InputStream)inputStream), this.$adbStream.getSink());
            }
        }), (int)31, null);
        try {
            Source source2 = (Source)adbStream.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)$client, (String)"client");
            this$0.forward(source2, Okio.buffer((Sink)Okio.sink((Socket)$client)));
        }
        finally {
            adbStream.close();
            $client.close();
            readerThread2.interrupt();
        }
    }

    public static final /* synthetic */ void access$handleForwarding(TcpForwarder $this) {
        $this.handleForwarding();
    }

    public static final /* synthetic */ void access$moveToState(TcpForwarder $this, State state) {
        $this.moveToState(state);
    }

    public static final /* synthetic */ State access$getState$p(TcpForwarder $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$forward(TcpForwarder $this, Source source2, BufferedSink sink2) {
        $this.forward(source2, sink2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ldadb/forwarding/TcpForwarder$State;", "", "(Ljava/lang/String;I)V", "STARTING", "STARTED", "STOPPING", "STOPPED", "dadb"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTING = new State();
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State STOPPING = new State();
        public static final /* enum */ State STOPPED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.STARTING, State.STARTED, State.STOPPING, State.STOPPED};
        }
    }
}

