/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime.servlet;

import dev.resteasy.grpc.bridge.runtime.i18n.Messages;
import dev.resteasy.grpc.bridge.runtime.servlet.AsyncContextImpl;
import io.undertow.util.DateUtils;
import io.undertow.util.LocaleUtils;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;

public class HttpServletRequestImpl
implements HttpServletRequest {
    public static final String GRPC_RETURN_RESPONSE = "grpc-return-response";
    public static final String LOCATOR = "LOCATOR";
    private ServletResponse servletResponse;
    private String uri;
    private String contextPath;
    private String path;
    private UriInfo uriInfo;
    private String servletPath;
    private String method;
    private ServletInputStream inputStream;
    private String returnType;
    private Map<String, List<String>> headers;
    private Cookie[] cookies;
    private ServletContext servletContext;
    private volatile boolean asyncStarted;
    private volatile AsyncContext asyncContext;
    private boolean gotInputStream = false;
    private boolean gotReader = false;
    private boolean readStarted;
    private String characterEncoding;
    private String clientAddr;
    private String clientHost;
    private int clientPort;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, String[]> formParameters;
    private Map<String, String[]> parameters;

    public HttpServletRequestImpl(ServletResponse servletResponse, ServletContext servletContext, String uri, String path, String method, ServletInputStream sis, String retn, Map<String, List<String>> headers, Cookie[] cookies, Map<String, String[]> formParameters) throws URISyntaxException {
        this.servletResponse = servletResponse;
        this.servletContext = servletContext;
        this.setUri(uri);
        this.contextPath = servletContext.getContextPath();
        this.path = path;
        this.method = method;
        this.inputStream = sis;
        this.returnType = retn;
        this.headers = headers == null ? new HashMap() : headers;
        this.cookies = cookies;
        this.formParameters = formParameters;
        ArrayList<String> acceptList = new ArrayList<String>();
        acceptList.add("application/grpc-jaxrs");
        acceptList.add("*/*;grpc-jaxrs=true");
        headers.put("Accept", acceptList);
        ArrayList<String> contentTypeList = new ArrayList<String>();
        contentTypeList.add("*/*;grpc-jaxrs=true");
        headers.put("Content-Type", contentTypeList);
        if ("com.google.protobuf.Any".equals(retn)) {
            acceptList = new ArrayList();
            acceptList.add("true");
            headers.put(GRPC_RETURN_RESPONSE, acceptList);
        }
        this.cookies = cookies;
        this.formParameters = formParameters;
    }

    public HttpServletRequestImpl() {
        ArrayList<String> acceptList = new ArrayList<String>();
        acceptList.add("application/grpc-jaxrs");
        acceptList.add("*/*;grpc-jaxrs=true");
        this.headers = new HashMap<String, List<String>>();
        this.headers.put("Accept", acceptList);
        ArrayList<String> contentTypeList = new ArrayList<String>();
        contentTypeList.add("*/*;grpc-jaxrs=true");
        this.headers.put("Content-Type", contentTypeList);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding;
        }
        String characterEncodingFromHeader = this.getCharacterEncodingFromHeader();
        if (characterEncodingFromHeader != null) {
            return characterEncodingFromHeader;
        }
        if (this.servletContext.getRequestCharacterEncoding() != null) {
            this.servletContext.getRequestCharacterEncoding();
        }
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.readStarted) {
            return;
        }
        this.characterEncoding = env;
    }

    public int getContentLength() {
        return -1;
    }

    public long getContentLengthLong() {
        return -1L;
    }

    public String getContentType() {
        return "*/*;grpc-jaxrs=true";
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.gotReader) {
            throw new IllegalStateException(Messages.MESSAGES.readerAlreadyReturned());
        }
        this.gotInputStream = true;
        this.readStarted = true;
        return this.inputStream;
    }

    public String getParameter(String name) {
        this.extractParameters();
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name)[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        this.extractParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        this.extractParameters();
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        this.extractParameters();
        return this.parameters;
    }

    public String getProtocol() {
        return "HTTP/2.0";
    }

    public String getScheme() {
        return this.getUriInfo().getBaseUri().getScheme();
    }

    public String getServerName() {
        return this.getUriInfo().getBaseUri().getHost();
    }

    public int getServerPort() {
        return this.getUriInfo().getBaseUri().getPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.gotInputStream) {
            throw new IllegalStateException(Messages.MESSAGES.inputStreamAlreadyReturned());
        }
        this.gotReader = true;
        this.readStarted = true;
        return new BufferedReader(new InputStreamReader((InputStream)this.inputStream));
    }

    public String getRemoteAddr() {
        return this.clientAddr;
    }

    public void setRemoteAddr(String addr) {
        this.clientAddr = addr;
    }

    public String getRemoteHost() {
        return this.clientHost;
    }

    public void setRemoteHost(String host) {
        this.clientHost = host;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public Enumeration<Locale> getLocales() {
        List<String> acceptLanguage = this.headers.get("Accept-Language");
        List ret = LocaleUtils.getLocalesFromHeader(acceptLanguage);
        if (ret.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(Locale.getDefault()));
        }
        return Collections.enumeration(ret);
    }

    public boolean isSecure() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isSecure()"));
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        Object realPath;
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            realPath = path;
        } else {
            String current = this.getUriInfo().relativize(this.getUriInfo().getBaseUri()).toString();
            int lastSlash = current.lastIndexOf("/");
            if (lastSlash != -1) {
                current = current.substring(0, lastSlash + 1);
            }
            realPath = current + path;
        }
        return this.servletContext.getRequestDispatcher((String)realPath);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public int getRemotePort() {
        return this.clientPort;
    }

    public void setRemotePort(int port) {
        this.clientPort = port;
    }

    public String getLocalName() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getLocalName()"));
    }

    public String getLocalAddr() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getLocalAddr()"));
    }

    public int getLocalPort() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getLocalPort()"));
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (this.asyncStarted) {
            throw Messages.MESSAGES.asyncProcessingAlreadyStarted();
        }
        this.asyncStarted = true;
        this.asyncContext = new AsyncContextImpl((ServletRequest)this, this.servletResponse);
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this != servletRequest && !(servletRequest instanceof ServletRequestWrapper)) {
            throw Messages.MESSAGES.requestWasNotOriginalOrWrapper(servletRequest);
        }
        if (this.servletResponse != servletResponse && !(servletResponse instanceof ServletResponseWrapper)) {
            throw Messages.MESSAGES.responseWasNotOriginalOrWrapper(servletResponse);
        }
        if (this.asyncStarted) {
            throw Messages.MESSAGES.asyncAlreadyStarted();
        }
        this.asyncContext = new AsyncContextImpl(servletRequest, servletResponse);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw Messages.MESSAGES.asyncNotStarted();
        }
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getAuthType() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getAuthType()"));
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.headers.get(name).get(0);
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)header);
        if (date == null) {
            throw Messages.MESSAGES.headerCannotBeConvertedToDate(header);
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        List<String> list = this.headers.get(name);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration((Collection)this.headers.get(name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public String getMethod() {
        return LOCATOR.equals(this.method) ? null : this.method;
    }

    public String getPathInfo() {
        return this.path;
    }

    public String getPathTranslated() {
        return this.getRealPath(this.getPathInfo());
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getQueryString() {
        return this.getUriInfo().getRequestUri().getQuery();
    }

    public String getRemoteUser() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getRemoteUser()"));
    }

    public boolean isUserInRole(String role) {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isUserInRole()"));
    }

    public Principal getUserPrincipal() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getUserPrincipal()"));
    }

    public String getRequestedSessionId() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getRequestedSessionId()"));
    }

    public String getRequestURI() {
        return this.getUriInfo().getAbsolutePath().toString();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getUriInfo().getAbsolutePath().toString());
    }

    public String getServletPath() {
        if (this.servletPath != null) {
            return this.servletPath;
        }
        int i = this.uri.indexOf(this.contextPath);
        if (i > -1) {
            int j = this.uri.substring(i += this.contextPath.length()).indexOf(this.path);
            this.servletPath = this.uri.substring(i, i + j);
        } else {
            String wholePath = this.getUriInfo().getPath();
            int j = wholePath.indexOf(this.path);
            this.servletPath = j > -1 ? wholePath.substring(0, j) : "";
        }
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getSession()"));
    }

    public HttpSession getSession() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getSession()"));
    }

    public String changeSessionId() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("changeSessionId()"));
    }

    public boolean isRequestedSessionIdValid() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isRequestedSessionIdValid()"));
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isRequestedSessionIdFromCookie()"));
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isRequestedSessionIdFromURL()"));
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("isRequestedSessionIdFromUrl()"));
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("authenticate()"));
    }

    public void login(String username, String password) throws ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("login()"));
    }

    public void logout() throws ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("logout()"));
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getParts()"));
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("getPart()"));
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new NotSupportedException(Messages.MESSAGES.isNotImplemented("upgrade()"));
    }

    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uriInfo = this.adjustUriInfo((UriInfo)new ResteasyUriInfo(uri, this.servletContext.getContextPath()));
        this.uri = this.uriInfo.getRequestUri().toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setInputStream(ServletInputStream sis) {
        this.inputStream = sis;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.putAll(headers);
    }

    public boolean isGotInputStream() {
        return this.gotInputStream;
    }

    public void setGotInputStream(boolean gotInputStream) {
        this.gotInputStream = gotInputStream;
    }

    public boolean isGotReader() {
        return this.gotReader;
    }

    public void setGotReader(boolean gotReader) {
        this.gotReader = gotReader;
    }

    public boolean isReadStarted() {
        return this.readStarted;
    }

    public void setReadStarted(boolean readStarted) {
        this.readStarted = readStarted;
    }

    public String getClientAddr() {
        return this.clientAddr;
    }

    public void setClientAddr(String clientAddr) {
        this.clientAddr = clientAddr;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String clientHost) {
        this.clientHost = clientHost;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String[]> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(Map<String, String[]> formParameters) {
        this.formParameters = formParameters;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public static String getGrpcReturnResponse() {
        return GRPC_RETURN_RESPONSE;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = this.adjustUriInfo(uriInfo);
        this.uri = uriInfo.getRequestUri().toString();
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted = asyncStarted;
    }

    public void setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
        if ("com.google.protobuf.Any".equals(returnType) || "Any".equals(returnType)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("true");
            this.headers.put(GRPC_RETURN_RESPONSE, list);
        }
    }

    private String getCharacterEncodingFromHeader() {
        String contentType = this.headers.get("Content-Type").get(0);
        if (contentType == null) {
            return null;
        }
        return HttpServletRequestImpl.extractQuotedValueFromHeader(contentType, "charset");
    }

    private static String extractQuotedValueFromHeader(String header, String key) {
        char c;
        int end;
        int keypos = 0;
        int pos = -1;
        boolean whiteSpace = true;
        boolean inQuotes = false;
        for (int i = 0; i < header.length() - 1; ++i) {
            char c2 = header.charAt(i);
            if (inQuotes) {
                if (c2 != '\"') continue;
                inQuotes = false;
                continue;
            }
            if (key.charAt(keypos) == c2 && (whiteSpace || keypos > 0)) {
                ++keypos;
                whiteSpace = false;
            } else if (c2 == '\"') {
                keypos = 0;
                inQuotes = true;
                whiteSpace = false;
            } else {
                keypos = 0;
                boolean bl = whiteSpace = c2 == ' ' || c2 == ';' || c2 == '\t';
            }
            if (keypos != key.length()) continue;
            if (header.charAt(i + 1) == '=') {
                pos = i + 2;
                break;
            }
            keypos = 0;
        }
        if (pos == -1) {
            return null;
        }
        int start = pos;
        if (header.charAt(start) == '\"') {
            char c3;
            for (end = ++start; end < header.length() && (c3 = header.charAt(end)) != '\"'; ++end) {
            }
            return header.substring(start, end);
        }
        for (end = start; end < header.length() && (c = header.charAt(end)) != ' ' && c != '\t' && c != ';'; ++end) {
        }
        return header.substring(start, end);
    }

    private UriInfo getUriInfo() {
        return this.uriInfo;
    }

    private void extractParameters() {
        if (this.parameters != null) {
            return;
        }
        this.parameters = this.formParameters;
        MultivaluedMap queryParams = this.getUriInfo().getQueryParameters();
        for (Map.Entry entry : queryParams.entrySet()) {
            if (this.parameters.containsKey(entry.getKey())) {
                int formLength = this.parameters.get(entry.getKey()).length;
                int queryLength = ((List)entry.getValue()).size();
                String[] array = Arrays.copyOf(this.parameters.get(entry.getKey()), formLength + queryLength);
                System.arraycopy(((List)entry.getValue()).toArray(), 0, array, formLength, queryLength);
                this.parameters.put((String)entry.getKey(), array);
                continue;
            }
            String[] array = new String[((List)entry.getValue()).size()];
            this.parameters.put((String)entry.getKey(), ((List)entry.getValue()).toArray(array));
        }
    }

    private UriInfo adjustUriInfo(UriInfo uriInfo) {
        String scheme = uriInfo.getRequestUri().getScheme();
        if (scheme == null || "".equals(scheme)) {
            Object u = uriInfo.getRequestUri().toString();
            if (((String)u).charAt(0) != '/') {
                u = "/" + (String)u;
            }
            u = "http://localhost:8080" + (String)u;
            uriInfo = new ResteasyUriInfo((String)u, this.servletContext.getContextPath());
        }
        return uriInfo;
    }
}

