/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.runtime.sse;

import dev.resteasy.grpc.bridge.runtime.servlet.AsyncMockServletOutputStream;
import dev.resteasy.grpc.bridge.runtime.servlet.HttpServletResponseImpl;
import dev.resteasy.grpc.bridge.runtime.sse.SseEvent;
import dev.resteasy.grpc.bridge.runtime.sse.SseEventOutputImpl;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class SseEventSinkInterceptor
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        ResourceMethodInvoker rmi = ((PostMatchContainerRequestContext)requestContext).getResourceMethod();
        if (rmi.isAsyncStreamProvider() || rmi.isSse()) {
            Dispatcher dispatcher = (Dispatcher)ResteasyContext.getContextData(Dispatcher.class);
            ResteasyProviderFactory providerFactory = dispatcher != null ? dispatcher.getProviderFactory() : ResteasyProviderFactory.getInstance();
            MessageBodyWriter writer = providerFactory.getMessageBodyWriter(SseEvent.class, null, null, MediaType.WILDCARD_TYPE);
            if (writer == null || !SseEventSinkInterceptor.isJavabufReaderWriter(writer)) {
                throw new RuntimeException("???");
            }
            HttpServletResponse response = (HttpServletResponse)ResteasyContext.getContextData(HttpServletResponse.class);
            if (!(response instanceof HttpServletResponseImpl)) {
                throw new RuntimeException("???");
            }
            AsyncMockServletOutputStream amsos = (AsyncMockServletOutputStream)response.getOutputStream();
            SseEventOutputImpl sink = new SseEventOutputImpl(writer, amsos);
            ResteasyContext.getContextDataMap().put(SseEventSink.class, sink);
        }
    }

    private static boolean isJavabufReaderWriter(MessageBodyWriter<?> writer) {
        try {
            Method method = writer.getClass().getDeclaredMethod("isWriteable", Class.class, Type.class, Annotation[].class, MediaType.class);
            return (Boolean)method.invoke(writer, SseEvent.class, null, null, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

