/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.generator.protobuf;

import com.github.javaparser.ParseResult;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.SourceRoot;
import dev.resteasy.grpc.bridge.generator.protobuf.JavabufTranslatorGenerator;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.logging.Logger;

public class JavaToProtobufGenerator {
    private static final Logger logger = Logger.getLogger(JavabufTranslatorGenerator.class);
    private static final String LS = System.lineSeparator();
    private static Map<String, String> TYPE_MAP = new HashMap<String, String>();
    private static Map<String, String> PRIMITIVE_WRAPPER_TYPES = new HashMap<String, String>();
    private static Map<String, String> PRIMITIVE_WRAPPER_DEFINITIONS = new HashMap<String, String>();
    private static Set<String> ANNOTATIONS = new HashSet<String>();
    private static Set<String> HTTP_VERBS = new HashSet<String>();
    private static String prefix;
    private static boolean needEmpty;
    private static List<ResolvedReferenceTypeDeclaration> resolvedTypes;
    private static Set<String> entityMessageTypes;
    private static Set<String> returnMessageTypes;
    private static Set<String> jars;
    private static Set<String> additionalClasses;
    private static Set<String> visited;
    private static JavaSymbolSolver symbolSolver;
    private static ClassVisitor classVisitor;
    private static JakartaRESTResourceVisitor jakartaRESTResourceVisitor;
    private static boolean started;
    private static int counter;
    private static boolean isSSE;
    private static String SSE_EVENT_CLASSNAME;

    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 4) {
            logger.info((Object)"need four args");
            logger.info((Object)"  arg[0]: root directory");
            logger.info((Object)"  arg[1]: package to be used in .proto file");
            logger.info((Object)"  arg[2]: java package to be used in .proto file");
            logger.info((Object)"  arg[3]: java outer classname to be generated from .proto file");
            logger.info((Object)"  -Djars: comma separated of jars [optional]");
            logger.info((Object)"  -Dclasses: comma separated of addition classes [optional]");
            return;
        }
        prefix = args[3];
        String s = System.getProperty("jars", "default");
        jars = "default".equals(s) || "".equals(s) ? new CopyOnWriteArraySet<String>() : new CopyOnWriteArraySet<String>(Arrays.asList(s.split(",")));
        s = System.getProperty("classes", "default");
        additionalClasses = "default".equals(s) || "".equals(s) ? new CopyOnWriteArraySet<String>() : new CopyOnWriteArraySet<String>(Arrays.asList(s.split(",")));
        StringBuilder sb = new StringBuilder();
        JavaToProtobufGenerator.protobufHeader(args, sb);
        new JavaToProtobufGenerator().processClasses(args, sb);
        while (!resolvedTypes.isEmpty()) {
            for (ResolvedReferenceTypeDeclaration rrtd : resolvedTypes) {
                classVisitor.visit(rrtd, sb);
            }
        }
        JavaToProtobufGenerator.finishProto(sb);
        JavaToProtobufGenerator.writeProtoFile(args, sb);
        JavaToProtobufGenerator.createProtobufDirectory(args);
    }

    private static void protobufHeader(String[] args, StringBuilder sb) {
        sb.append("syntax = \"proto3\";" + LS);
        sb.append("package " + args[1].replace('-', '.') + ";" + LS);
        sb.append("import \"google/protobuf/any.proto\";" + LS);
        sb.append("import \"google/protobuf/timestamp.proto\";" + LS);
        sb.append("option java_package = \"" + args[2] + "\";" + LS);
        sb.append("option java_outer_classname = \"" + args[3] + "_proto\";" + LS);
    }

    private void processClasses(String[] args, StringBuilder sb) throws IOException {
        Log.setAdapter((Log.Adapter)new Log.StandardOutStandardErrorAdapter());
        Path path = Path.of(args[0], "/src/main/java/");
        SourceRoot sourceRoot = new SourceRoot(path);
        ReflectionTypeSolver reflectionTypeSolver = new ReflectionTypeSolver();
        JavaParserTypeSolver javaParserTypeSolver = new JavaParserTypeSolver(path);
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)reflectionTypeSolver);
        combinedTypeSolver.add((TypeSolver)javaParserTypeSolver);
        for (String s : jars) {
            combinedTypeSolver.add((TypeSolver)new JarTypeSolver(s));
        }
        symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        sourceRoot.getParserConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        List list = sourceRoot.tryToParseParallelized();
        for (ParseResult p : list) {
            jakartaRESTResourceVisitor.visit((CompilationUnit)p.getResult().get(), sb);
        }
        if (started) {
            sb.append("}" + LS);
        }
        JavaToProtobufGenerator.processAdditionalClasses(symbolSolver, sb);
    }

    private static void processAdditionalClasses(JavaSymbolSolver symbolSolver, StringBuilder sb) throws FileNotFoundException {
        StaticJavaParser.getConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        while (!additionalClasses.isEmpty()) {
            for (String string : additionalClasses) {
                int n = string.indexOf(":");
                if (n < 0) {
                    throw new RuntimeException("bad syntax: " + string);
                }
                String dir = string.substring(0, n).trim();
                String string2 = dir + "/" + string.substring(n + 1).replace(".", "/") + ".java";
                CompilationUnit cu = StaticJavaParser.parse((File)new File(string2));
                AdditionalClassVisitor additionalClassVisitor = new AdditionalClassVisitor(dir);
                additionalClassVisitor.visit(cu, sb);
            }
        }
        if (isSSE) {
            sb.append(LS).append("message dev_resteasy_grpc_bridge_runtime_sse___SseEvent {" + LS).append("  string comment = ").append(counter++).append(";").append(LS).append("  string id = ").append(counter++).append(";").append(LS).append("  string name = ").append(counter++).append(";").append(LS).append("  google.protobuf.Any data = ").append(counter++).append(";").append(LS).append("  int64 reconnectDelay = ").append(counter++).append(";").append(LS).append("}").append(LS);
        }
    }

    private static void finishProto(StringBuilder sb) {
        if (needEmpty) {
            sb.append(LS + "message gEmpty {}");
            entityMessageTypes.add("gEmpty");
            returnMessageTypes.add("gEmpty");
        }
        for (String wrapper : PRIMITIVE_WRAPPER_DEFINITIONS.values()) {
            sb.append(LS).append(wrapper.replace("$V$", String.valueOf(counter++)));
        }
        JavaToProtobufGenerator.createGeneralEntityMessageType(sb);
        JavaToProtobufGenerator.createGeneralReturnMessageType(sb);
    }

    private static void createGeneralEntityMessageType(StringBuilder sb) {
        sb.append(LS + LS + "message gHeader {" + LS).append("   repeated string values = ").append(counter++).append(";" + LS + "}");
        sb.append(LS + LS + "message gCookie {" + LS).append("   string name = ").append(counter++).append(";" + LS).append("   string value = ").append(counter++).append(";" + LS).append("   int32  version = ").append(counter++).append(";" + LS).append("   string path = ").append(counter++).append(";" + LS).append("   string domain = ").append(counter++).append(";" + LS).append("}");
        sb.append(LS + LS + "message gNewCookie {" + LS).append("   string name = ").append(counter++).append(";" + LS).append("   string value = ").append(counter++).append(";" + LS).append("   int32  version = ").append(counter++).append(";" + LS).append("   string path = ").append(counter++).append(";" + LS).append("   string domain = ").append(counter++).append(";" + LS).append("   string comment = ").append(counter++).append(";" + LS).append("   int32 maxAge = ").append(counter++).append(";" + LS).append("   google.protobuf.Timestamp expiry = ").append(counter++).append(";" + LS).append("   bool secure = ").append(counter++).append(";" + LS).append("   bool httpOnly = ").append(counter++).append(";" + LS + LS).append("   enum SameSite {" + LS).append("      NONE   = 0;" + LS).append("      LAX    = 1;" + LS).append("      STRICT = 2;" + LS).append("   }" + LS + LS).append("   SameSite sameSite = ").append(counter++).append(";" + LS).append("}");
        sb.append(LS + LS + "message ServletInfo {" + LS).append("   string characterEncoding = ").append(counter++).append(";" + LS).append("   string clientAddress = ").append(counter++).append(";" + LS).append("   string clientHost = ").append(counter++).append(";" + LS).append("   int32  clientPort = ").append(counter++).append(";" + LS).append("}");
        sb.append(LS + LS + "message FormValues {" + LS).append("   repeated string formValues_field = ").append(counter++).append(";" + LS).append("}");
        sb.append(LS + LS + "message FormMap {" + LS).append("   map<string, FormValues> formMap_field = ").append(counter++).append(";" + LS).append("}");
        sb.append(LS + LS + "message GeneralEntityMessage {" + LS).append("   ServletInfo servletInfo = ").append(counter++).append(";" + LS).append("   string URL = ").append(counter++).append(";" + LS).append("   map<string, gHeader> headers = ").append(counter++).append(";" + LS).append("   repeated gCookie cookies = ").append(counter++).append(";" + LS).append("   string httpMethod = ").append(counter++).append(";" + LS).append("   oneof messageType {" + LS);
        for (String messageType : entityMessageTypes) {
            sb.append("      ").append(messageType).append(" ").append(JavaToProtobufGenerator.namify(messageType)).append("_field").append(" = ").append(counter++).append(";" + LS);
        }
        sb.append("      FormMap form_field = ").append(counter++).append(";" + LS);
        sb.append("   }" + LS + "}" + LS);
    }

    private static void createGeneralReturnMessageType(StringBuilder sb) {
        sb.append(LS + "message GeneralReturnMessage {" + LS).append("   map<string, gHeader> headers = ").append(counter++).append(";" + LS).append("   repeated gNewCookie cookies = ").append(counter++).append(";" + LS).append("   gInteger status = ").append(counter++).append(";" + LS).append("   oneof messageType {" + LS);
        for (String messageType : returnMessageTypes) {
            sb.append("      ").append(messageType).append(" ").append(JavaToProtobufGenerator.namify(messageType)).append("_field").append(" = ").append(counter++).append(";" + LS);
        }
        sb.append("   }" + LS + "}" + LS);
    }

    private static void writeProtoFile(String[] args, StringBuilder sb) throws IOException {
        Path path = Files.createDirectories(Path.of(args[0], "src", "main", "proto"), new FileAttribute[0]);
        if (path.resolve(args[3] + ".proto").toFile().exists()) {
            return;
        }
        Files.writeString(path.resolve(args[3] + ".proto"), (CharSequence)sb.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static void createProtobufDirectory(String[] args) {
        String path = args[0] + "/target/generatedSources";
        for (String s : args[1].split("\\.")) {
            File dir = new File(path = path + "/" + s);
            if (dir.exists()) continue;
            dir.mkdir();
        }
    }

    private static String getPackageName(ClassOrInterfaceDeclaration clazz) {
        String fqn = clazz.getFullyQualifiedName().orElse(null);
        if (fqn == null) {
            return null;
        }
        int index = fqn.lastIndexOf(".");
        return fqn.substring(0, index);
    }

    private static String getEntityParameter(MethodDeclaration md, String httpMethod) {
        if ("LOCATOR".equals(httpMethod)) {
            return "google.protobuf.Any";
        }
        for (Parameter p : md.getParameters()) {
            if (!JavaToProtobufGenerator.isEntity(p)) continue;
            String rawType = p.getTypeAsString();
            if (PRIMITIVE_WRAPPER_TYPES.containsKey(rawType)) {
                return PRIMITIVE_WRAPPER_TYPES.get(rawType);
            }
            ResolvedType rt = p.getType().resolve();
            resolvedTypes.add((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get());
            String type = rt.describe();
            return JavaToProtobufGenerator.fqnifyClass(type, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get()));
        }
        needEmpty = true;
        return "gEmpty";
    }

    private static boolean isEntity(Parameter p) {
        for (AnnotationExpr ae : p.getAnnotations()) {
            if (!ANNOTATIONS.contains(ae.getNameAsString())) continue;
            return false;
        }
        String name = p.getTypeAsString();
        return !AsyncResponse.class.getName().equals(name) && !AsyncResponse.class.getSimpleName().equals(name);
    }

    private static String getReturnType(MethodDeclaration md, String httpMethod) {
        if (JavaToProtobufGenerator.isSuspended(md) || "LOCATOR".equals(httpMethod)) {
            return "google.protobuf.Any";
        }
        if (JavaToProtobufGenerator.isSSE(md)) {
            return SSE_EVENT_CLASSNAME;
        }
        for (Node node : md.getChildNodes()) {
            if (!(node instanceof Type)) continue;
            if (node instanceof VoidType) {
                return "google.protobuf.Any";
            }
            String rawType = ((Type)node).asString();
            int open = rawType.indexOf("<");
            int close = rawType.indexOf(">");
            if (open >= 0 && close > open) {
                String type = rawType.substring(0, open);
                String parameterType = rawType.substring(open + 1, close);
                rawType = CompletionStage.class.getCanonicalName().contentEquals(type) || CompletionStage.class.getSimpleName().contentEquals(type) ? parameterType : type;
            }
            if (PRIMITIVE_WRAPPER_TYPES.containsKey(rawType)) {
                return PRIMITIVE_WRAPPER_TYPES.get(rawType);
            }
            if ("jakarta.ws.rs.core.Response".equals(rawType) || "Response".equals(rawType)) {
                return "google.protobuf.Any";
            }
            ResolvedType rt = ((Type)node).resolve();
            resolvedTypes.add((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get());
            String type = ((Type)node).resolve().describe();
            return JavaToProtobufGenerator.fqnifyClass(type, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rt.asReferenceType().getTypeDeclaration().get()));
        }
        needEmpty = true;
        return "gEmpty";
    }

    private static boolean isSuspended(MethodDeclaration md) {
        for (Parameter p : md.getParameters()) {
            for (AnnotationExpr ae : p.getAnnotations()) {
                if (!"Suspended".equals(ae.getNameAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCompletionStage(MethodDeclaration md) {
        for (Node node : md.getChildNodes()) {
            if (!(node instanceof Type)) continue;
            String rawType = ((Type)node).asString();
            int open = rawType.indexOf("<");
            int close = rawType.indexOf(">");
            if (open < 0 || close <= open) continue;
            String type = rawType.substring(0, open);
            if (!CompletionStage.class.getCanonicalName().contentEquals(type) && !CompletionStage.class.getSimpleName().contentEquals(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSSE(MethodDeclaration md) {
        Optional opt = md.getAnnotationByName("Produces");
        if (opt.isEmpty()) {
            return false;
        }
        AnnotationExpr ae = (AnnotationExpr)opt.get();
        List list1 = ae.findAll(StringLiteralExpr.class);
        for (StringLiteralExpr sle : list1) {
            if (!"text/event-stream".equals(sle.getValue())) continue;
            isSSE = true;
            return true;
        }
        List list2 = ae.findAll(FieldAccessExpr.class);
        for (FieldAccessExpr fae : list2) {
            List list3 = fae.getChildNodes();
            if (list3.size() < 2 || !(list3.get(0) instanceof NameExpr) || !(list3.get(1) instanceof SimpleName)) continue;
            NameExpr ne = (NameExpr)list3.get(0);
            SimpleName sn = (SimpleName)list3.get(1);
            if (!"MediaType".equals(ne.getName().asString()) || !"SERVER_SENT_EVENTS".equals(sn.asString())) continue;
            isSSE = true;
            return true;
        }
        return false;
    }

    private static boolean isResourceOrLocatorMethod(MethodDeclaration md) {
        for (AnnotationExpr ae : md.getAnnotations()) {
            if (!HTTP_VERBS.contains(ae.getNameAsString().toUpperCase()) && !"Path".equals(ae.getNameAsString())) continue;
            return true;
        }
        return false;
    }

    private static String removeTypeVariables(String classType) {
        int left = classType.indexOf(60);
        if (left < 0) {
            return classType;
        }
        return classType.substring(0, left);
    }

    private static boolean isInnerClass(ResolvedReferenceTypeDeclaration clazz) {
        try {
            Optional opt = clazz.containerType();
            if (opt.isEmpty()) {
                return false;
            }
            ResolvedTypeDeclaration rtd = (ResolvedTypeDeclaration)clazz.containerType().get();
            return rtd.isClass();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isInnerClass(ClassOrInterfaceDeclaration clazz) {
        return clazz.isNestedType();
    }

    private static String fqnifyClass(String s, boolean isInnerClass) {
        int l = s.lastIndexOf(".");
        String sPackage = s.substring(0, l).replace(".", "_");
        String separator = isInnerClass ? "_INNER_" : "___";
        String className = s.substring(l + 1);
        return sPackage + separator + className;
    }

    private static String namify(String s) {
        return s.replace(".", "_");
    }

    private static String getHttpMethod(MethodDeclaration md) {
        if (!md.getAnnotationByName("DELETE").isEmpty()) {
            return "DELETE";
        }
        if (!md.getAnnotationByName("GET").isEmpty()) {
            return "GET";
        }
        if (!md.getAnnotationByName("HEAD").isEmpty()) {
            return "HEAD";
        }
        if (!md.getAnnotationByName("OPTIONS").isEmpty()) {
            return "OPTIONS";
        }
        if (!md.getAnnotationByName("PATCH").isEmpty()) {
            return "PATCH";
        }
        if (!md.getAnnotationByName("POST").isEmpty()) {
            return "POST";
        }
        if (!md.getAnnotationByName("PUT").isEmpty()) {
            return "PUT";
        }
        return "LOCATOR";
    }

    static {
        needEmpty = false;
        resolvedTypes = new CopyOnWriteArrayList<ResolvedReferenceTypeDeclaration>();
        entityMessageTypes = new HashSet<String>();
        returnMessageTypes = new HashSet<String>();
        visited = new HashSet<String>();
        classVisitor = new ClassVisitor();
        jakartaRESTResourceVisitor = new JakartaRESTResourceVisitor();
        started = false;
        counter = 1;
        SSE_EVENT_CLASSNAME = "dev_resteasy_grpc_bridge_runtime_sse___SseEvent";
        TYPE_MAP.put("boolean", "bool");
        TYPE_MAP.put("byte", "int32");
        TYPE_MAP.put("short", "int32");
        TYPE_MAP.put("int", "int32");
        TYPE_MAP.put("long", "int64");
        TYPE_MAP.put("float", "float");
        TYPE_MAP.put("double", "double");
        TYPE_MAP.put("boolean", "bool");
        TYPE_MAP.put("char", "int32");
        TYPE_MAP.put("String", "string");
        TYPE_MAP.put("java.lang.String", "string");
        PRIMITIVE_WRAPPER_TYPES.put("boolean", "gBoolean");
        PRIMITIVE_WRAPPER_TYPES.put("byte", "gByte");
        PRIMITIVE_WRAPPER_TYPES.put("short", "gShort");
        PRIMITIVE_WRAPPER_TYPES.put("int", "gInteger");
        PRIMITIVE_WRAPPER_TYPES.put("long", "gLong");
        PRIMITIVE_WRAPPER_TYPES.put("float", "gFloat");
        PRIMITIVE_WRAPPER_TYPES.put("double", "gDouble");
        PRIMITIVE_WRAPPER_TYPES.put("boolean", "gBoolean");
        PRIMITIVE_WRAPPER_TYPES.put("char", "gCharacter");
        PRIMITIVE_WRAPPER_TYPES.put("string", "gString");
        PRIMITIVE_WRAPPER_TYPES.put("Boolean", "gBoolean");
        PRIMITIVE_WRAPPER_TYPES.put("Byte", "gByte");
        PRIMITIVE_WRAPPER_TYPES.put("Short", "gShort");
        PRIMITIVE_WRAPPER_TYPES.put("Integer", "gInteger");
        PRIMITIVE_WRAPPER_TYPES.put("Long", "gLong");
        PRIMITIVE_WRAPPER_TYPES.put("Float", "gFloat");
        PRIMITIVE_WRAPPER_TYPES.put("Double", "gDouble");
        PRIMITIVE_WRAPPER_TYPES.put("Boolean", "gBoolean");
        PRIMITIVE_WRAPPER_TYPES.put("Character", "gCharacter");
        PRIMITIVE_WRAPPER_TYPES.put("String", "gString");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.String", "gString");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Byte", "gByte");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Short", "gShort");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Integer", "gInteger");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Long", "gLong");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Float", "gFloat");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Double", "gDouble");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Boolean", "gBoolean");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.Character", "gCharacter");
        PRIMITIVE_WRAPPER_TYPES.put("java.lang.String", "gString");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Boolean", "message gBoolean   {bool   value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Byte", "message gByte      {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Short", "message gShort     {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Integer", "message gInteger   {int32  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Long", "message gLong      {int64  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Float", "message gFloat     {float  value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Double", "message gDouble    {double value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("Character", "message gCharacter {string value = $V$;}");
        PRIMITIVE_WRAPPER_DEFINITIONS.put("String", "message gString    {string value = $V$;}");
        ANNOTATIONS.add("Context");
        ANNOTATIONS.add("CookieParam");
        ANNOTATIONS.add("HeaderParam");
        ANNOTATIONS.add("MatrixParam");
        ANNOTATIONS.add("PathParam");
        ANNOTATIONS.add("QueryParam");
        HTTP_VERBS.add("DELETE");
        HTTP_VERBS.add("HEAD");
        HTTP_VERBS.add("GET");
        HTTP_VERBS.add("OPTIONS");
        HTTP_VERBS.add("PATCH");
        HTTP_VERBS.add("POST");
        HTTP_VERBS.add("PUT");
    }

    static class AdditionalClassVisitor
    extends VoidVisitorAdapter<StringBuilder> {
        private String dir;

        AdditionalClassVisitor(String dir) {
            this.dir = dir;
        }

        public void visit(ClassOrInterfaceDeclaration clazz, StringBuilder sb) {
            if (PRIMITIVE_WRAPPER_DEFINITIONS.containsKey(clazz.getName().asString())) {
                return;
            }
            String packageName = JavaToProtobufGenerator.getPackageName(clazz);
            Object fqn = packageName + "." + clazz.getNameAsString();
            String filename = this.dir + ":" + (String)fqn;
            additionalClasses.remove(filename);
            if (visited.contains(fqn)) {
                return;
            }
            visited.add((String)fqn);
            sb.append(LS + "message ").append(JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass(clazz))).append(" {" + LS);
            for (FieldDeclaration fd : clazz.getFields()) {
                ResolvedFieldDeclaration rfd = fd.resolve();
                ResolvedType type = rfd.getType();
                Object typeName = type.describe();
                if (TYPE_MAP.containsKey(typeName)) {
                    typeName = TYPE_MAP.get(typeName);
                } else if (type.isArray()) {
                    ResolvedType ct = type.asArrayType().getComponentType();
                    if ("byte".equals(ct.describe())) {
                        typeName = "bytes";
                    } else if (ct.isPrimitive()) {
                        typeName = "repeated " + (String)typeName;
                    } else {
                        fqn = type.describe();
                        additionalClasses.add(this.dir + ":" + (String)fqn);
                        typeName = "repeated " + JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)type.asReferenceType().getTypeDeclaration().get()));
                    }
                } else {
                    fqn = type.describe();
                    additionalClasses.add(this.dir + ":" + (String)fqn);
                    typeName = JavaToProtobufGenerator.fqnifyClass(type.describe(), JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)type.asReferenceType().getTypeDeclaration().get()));
                }
                if (type == null) continue;
                sb.append("  ").append((String)typeName).append(" ").append(rfd.getName()).append(" = ").append(counter++).append(";" + LS);
            }
            for (ResolvedReferenceType rrt : clazz.resolve().getAllAncestors()) {
                if (Object.class.getName().equals(rrt.getQualifiedName()) || !(rrt.getTypeDeclaration().get() instanceof JavaParserClassDeclaration)) continue;
                JavaParserClassDeclaration jpcd = (JavaParserClassDeclaration)rrt.getTypeDeclaration().get();
                ResolvedClassDeclaration rcd = jpcd.asClass();
                if (Object.class.getName().equals(rcd.getClassName())) continue;
                fqn = rcd.getPackageName() + "." + rcd.getName();
                if (!visited.contains(fqn)) {
                    additionalClasses.add(this.dir + ":" + (String)fqn);
                }
                fqn = JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rcd));
                String superClassName = rcd.getName();
                String superClassVariableName = Character.toString(Character.toLowerCase(superClassName.charAt(0))).concat(superClassName.substring(1)) + "___super";
                sb.append("  ").append((String)fqn).append(" ").append(superClassVariableName).append(" = ").append(counter++).append(";" + LS);
                break;
            }
            sb.append("}" + LS);
        }
    }

    static class ClassVisitor
    extends VoidVisitorAdapter<StringBuilder> {
        ClassVisitor() {
        }

        public void visit(ResolvedReferenceTypeDeclaration clazz, StringBuilder sb) {
            resolvedTypes.remove(clazz);
            if (clazz.isInterface()) {
                return;
            }
            if (clazz.getPackageName().startsWith("java")) {
                return;
            }
            if (PRIMITIVE_WRAPPER_DEFINITIONS.containsKey(clazz.getClassName())) {
                return;
            }
            if (Response.class.getName().equals(clazz.getQualifiedName())) {
                return;
            }
            Object fqn = clazz.getQualifiedName();
            if (visited.contains(fqn)) {
                return;
            }
            visited.add((String)fqn);
            sb.append(LS + "message ").append(JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass(clazz))).append(" {" + LS);
            for (ResolvedFieldDeclaration rfd : clazz.getDeclaredFields()) {
                Object type = null;
                if (rfd.getType().isPrimitive() || rfd.getType().isReferenceType() && String.class.getName().equals(rfd.getType().asReferenceType().getQualifiedName())) {
                    type = TYPE_MAP.get(rfd.getType().describe());
                } else if (rfd.getType() instanceof ResolvedArrayType) {
                    ResolvedArrayType rat = (ResolvedArrayType)rfd.getType();
                    ResolvedType ct = rat.getComponentType();
                    if ("byte".equals(ct.describe())) {
                        type = "bytes";
                    } else if (ct.isPrimitive()) {
                        type = "repeated " + TYPE_MAP.get(JavaToProtobufGenerator.removeTypeVariables(ct.describe()));
                    } else {
                        fqn = JavaToProtobufGenerator.removeTypeVariables(ct.describe());
                        if (!ct.isReferenceType()) continue;
                        if (!visited.contains(fqn)) {
                            resolvedTypes.add((ResolvedReferenceTypeDeclaration)ct.asReferenceType().getTypeDeclaration().get());
                        }
                        type = "repeated " + JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)ct.asReferenceType().getTypeDeclaration().get()));
                    }
                } else if (rfd.getType().isReferenceType()) {
                    ResolvedReferenceTypeDeclaration rrtd = (ResolvedReferenceTypeDeclaration)rfd.getType().asReferenceType().getTypeDeclaration().get();
                    fqn = rrtd.getPackageName() + "." + rrtd.getClassName();
                    if (!visited.contains(fqn)) {
                        resolvedTypes.add(rrtd);
                    }
                    type = JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass(rrtd));
                } else if (rfd.getType().isTypeVariable()) {
                    type = "bytes ";
                }
                if (type == null) continue;
                sb.append("  ").append((String)type).append(" ").append(rfd.getName()).append(" = ").append(counter++).append(";" + LS);
            }
            for (ResolvedReferenceType rrt : clazz.getAncestors()) {
                if (rrt.getTypeDeclaration().get() instanceof ReflectionClassDeclaration) {
                    ReflectionClassDeclaration rcd = (ReflectionClassDeclaration)rrt.getTypeDeclaration().get();
                    if (Object.class.getName().equals(rcd.getQualifiedName())) continue;
                    fqn = JavaToProtobufGenerator.fqnifyClass(rcd.getPackageName() + "." + rcd.getName(), JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rrt.getTypeDeclaration().get()));
                    if (!visited.contains(fqn)) {
                        resolvedTypes.add((ResolvedReferenceTypeDeclaration)rcd);
                    }
                    String superClassName = rcd.getName();
                    String superClassVariableName = Character.toString(Character.toLowerCase(superClassName.charAt(0))).concat(superClassName.substring(1)) + "___super";
                    sb.append("  ").append((String)fqn).append(" ").append(superClassVariableName).append(" = ").append(counter++).append(";" + LS);
                    break;
                }
                if (!(rrt.getTypeDeclaration().get() instanceof JavaParserClassDeclaration)) continue;
                JavaParserClassDeclaration jpcd = (JavaParserClassDeclaration)rrt.getTypeDeclaration().get();
                ResolvedClassDeclaration rcd = jpcd.asClass();
                if (Object.class.getName().equals(rcd.getClassName())) continue;
                fqn = rcd.getPackageName() + "." + rcd.getName();
                if (!visited.contains(fqn)) {
                    resolvedTypes.add((ResolvedReferenceTypeDeclaration)rcd);
                }
                fqn = JavaToProtobufGenerator.fqnifyClass((String)fqn, JavaToProtobufGenerator.isInnerClass((ResolvedReferenceTypeDeclaration)rrt.getTypeDeclaration().get()));
                String superClassName = rcd.getName();
                String superClassVariableName = Character.toString(Character.toLowerCase(superClassName.charAt(0))).concat(superClassName.substring(1)) + "___super";
                sb.append("  ").append((String)fqn).append(" ").append(superClassVariableName).append(" = ").append(counter++).append(";" + LS);
                break;
            }
            sb.append("}" + LS);
        }
    }

    static class JakartaRESTResourceVisitor
    extends VoidVisitorAdapter<StringBuilder> {
        JakartaRESTResourceVisitor() {
        }

        public void visit(ClassOrInterfaceDeclaration subClass, StringBuilder sb) {
            if (subClass.getFullyQualifiedName().orElse("").startsWith("grpc.server")) {
                return;
            }
            Optional opt = subClass.getAnnotationByName("Path");
            SingleMemberAnnotationExpr annotationExpr = opt.isPresent() ? (SingleMemberAnnotationExpr)opt.get() : null;
            String classPath = "";
            if (annotationExpr != null) {
                classPath = annotationExpr.getMemberValue().toString();
                classPath = classPath.substring(1, classPath.length() - 1);
            }
            for (BodyDeclaration bd : subClass.getMembers()) {
                MethodDeclaration md;
                if (!(bd instanceof MethodDeclaration) || !JavaToProtobufGenerator.isResourceOrLocatorMethod(md = (MethodDeclaration)bd)) continue;
                String methodPath = "";
                opt = md.getAnnotationByName("Path");
                SingleMemberAnnotationExpr singleMemberAnnotationExpr = annotationExpr = opt.isPresent() ? (SingleMemberAnnotationExpr)opt.get() : null;
                if (annotationExpr != null) {
                    methodPath = annotationExpr.getMemberValue().toString();
                    methodPath = methodPath.substring(1, methodPath.length() - 1);
                }
                String httpMethod = JavaToProtobufGenerator.getHttpMethod(md);
                if (!started) {
                    sb.append(LS + "service ").append(prefix).append("Service {" + LS);
                    started = true;
                }
                String entityType = JavaToProtobufGenerator.getEntityParameter(md, httpMethod);
                String returnType = JavaToProtobufGenerator.getReturnType(md, httpMethod);
                String syncType = JavaToProtobufGenerator.isSuspended(md) ? "suspended" : (JavaToProtobufGenerator.isCompletionStage(md) ? "completionStage" : (JavaToProtobufGenerator.isSSE(md) ? "sse" : "sync"));
                JavaToProtobufGenerator.isSuspended(md);
                sb.append("// ");
                if (!"".equals(classPath)) {
                    sb.append(classPath).append("/");
                }
                sb.append(methodPath).append(" ").append(entityType).append(" ").append(returnType).append(" ").append(httpMethod).append(" ").append(syncType).append(LS);
                entityMessageTypes.add(entityType);
                returnMessageTypes.add(returnType);
                sb.append("  rpc ").append(md.getNameAsString()).append(" (").append("GeneralEntityMessage").append(") returns (").append("sse".equals(syncType) ? "stream " : "").append("sse".equals(syncType) ? SSE_EVENT_CLASSNAME : "GeneralReturnMessage").append(");" + LS);
                for (Parameter p : md.getParameters()) {
                    if (!JavaToProtobufGenerator.isEntity(p) || p.getType().resolve().isPrimitive()) continue;
                    ReferenceTypeImpl rt = (ReferenceTypeImpl)p.getType().resolve();
                    ResolvedReferenceTypeDeclaration rrtd = (ResolvedReferenceTypeDeclaration)rt.getTypeDeclaration().get();
                    String type = rt.asReferenceType().getQualifiedName();
                    if (visited.contains(type)) continue;
                    resolvedTypes.add(rrtd);
                }
            }
        }
    }
}

