/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.bridge.generator;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class SourceWriter
implements AutoCloseable {
    private final BufferedWriter writer;
    private final int indentation;
    private int indent;

    SourceWriter(Path file) throws IOException {
        this.writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);
        this.indentation = 4;
    }

    SourceWriter startBlock(String line) throws IOException {
        this.writeLine(line);
        this.indent += this.indentation;
        return this;
    }

    SourceWriter startBlock(String ... text) throws IOException {
        for (String s : text) {
            this.writer.write(s);
        }
        this.indent += this.indentation;
        return this;
    }

    SourceWriter writeLine() throws IOException {
        this.writer.newLine();
        return this;
    }

    SourceWriter writeLine(String line) throws IOException {
        if (line.isBlank()) {
            this.writer.newLine();
            return this;
        }
        if (this.indent != 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.append(' ');
            }
        }
        this.writer.write(line);
        this.writer.newLine();
        return this;
    }

    SourceWriter writeLine(String ... text) throws IOException {
        if (this.indent != 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.append(' ');
            }
        }
        for (String s : text) {
            this.writer.write(s);
        }
        this.writer.newLine();
        return this;
    }

    SourceWriter endBlock() throws IOException {
        return this.endBlock("}");
    }

    SourceWriter endBlock(String line) throws IOException {
        this.indent -= this.indentation;
        if (this.indent < 0) {
            this.indent = 0;
        }
        return this.writeLine(line);
    }

    SourceWriter endAndStart(String line) throws IOException {
        this.indent -= this.indentation;
        if (this.indent < 0) {
            this.indent = 0;
        }
        return this.startBlock(line);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

