/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.grpc.example;

import dev.resteasy.grpc.example.CC2;
import dev.resteasy.grpc.example.CC3;
import dev.resteasy.grpc.example.CC4;
import dev.resteasy.grpc.example.CC5;
import dev.resteasy.grpc.example.CC6;
import dev.resteasy.grpc.example.CC7;
import dev.resteasy.grpc.example.CC9;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;

@Path(value="p")
public class CC1 {
    @Path(value="ready")
    @GET
    public String ready() {
        System.out.println("gRPC server ready");
        return "ready";
    }

    @Path(value="boolean")
    @POST
    public boolean getBoolean(boolean b) {
        return !b;
    }

    @Path(value="Boolean")
    @POST
    public Boolean getBooleanWrapper(Boolean b) {
        return b == false;
    }

    @Path(value="byte")
    @POST
    public byte getByte(byte b) {
        int i = b + 1;
        return (byte)i;
    }

    @Path(value="Byte")
    @POST
    public Byte getByteWrapper(Byte b) {
        return (byte)(b + 1);
    }

    @Path(value="short")
    @POST
    public short getShort(short n) {
        int i = n + 1;
        return (short)i;
    }

    @Path(value="Short")
    @POST
    public Short getShortWrapper(Short n) {
        return (short)(n + 1);
    }

    @Path(value="int")
    @POST
    public int getInt(int n) {
        return n + 1;
    }

    @Path(value="Integer")
    @POST
    public Integer getInteger(Integer n) {
        return n + 1;
    }

    @Path(value="long")
    @POST
    public long getLong(long n) {
        return n + 1L;
    }

    @Path(value="Long")
    @POST
    public Long getLongWrapper(Long n) {
        return n + 1L;
    }

    @Path(value="float")
    @POST
    public float getFloat(float f) {
        return Float.valueOf(f + 1.0f).floatValue();
    }

    @Path(value="Float")
    @POST
    public Float getFloatWrapper(Float f) {
        return Float.valueOf(f.floatValue() + 1.0f);
    }

    @Path(value="double")
    @POST
    public double getDouble(double d) {
        return d + 1.0;
    }

    @Path(value="Double")
    @POST
    public Double getDoubleWrapper(Double d) {
        return (double)d.floatValue() + 1.0;
    }

    @Path(value="char")
    @POST
    public char getChar(char c) {
        return Character.toUpperCase(c);
    }

    @Path(value="Character")
    @POST
    public Character getCharacter(Character c) {
        return Character.valueOf(Character.toUpperCase(c.charValue()));
    }

    @Path(value="string")
    @POST
    public String getString(String s) {
        return s.toUpperCase();
    }

    @Path(value="constructor")
    @GET
    public CC9 constructor() {
        return new CC9(true, 1, 2, 3, 4L, 5.0f, 6.0, '7', new CC3("eight"));
    }

    @Path(value="response")
    @GET
    public Response getResponse() {
        CC7 cc7 = new CC7("cc7", 11);
        return Response.ok((Object)cc7).build();
    }

    @Path(value="async/cs")
    @GET
    public CompletionStage<String> getResponseCompletionStage() {
        final CompletableFuture<String> response = new CompletableFuture<String>();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    response.complete("cs");
                }
                catch (Exception e) {
                    response.completeExceptionally(e);
                }
            }
        };
        t.start();
        return response;
    }

    @Path(value="cc7")
    @GET
    public CC7 getCC7() {
        CC7 cc7 = new CC7("cc7", 11);
        return cc7;
    }

    @Path(value="produces")
    @Produces(value={"abc/xyz"})
    @GET
    public String produces() {
        return "produces";
    }

    @Path(value="consumes")
    @Consumes(value={"xyz/abc"})
    @GET
    public String consumes() {
        return "consumes";
    }

    @Path(value="path/{p1}/param/{p2}")
    @GET
    public String pathParams(@PathParam(value="p1") String p1, @PathParam(value="p2") String p2) {
        return "x" + p1 + "y" + p2 + "z";
    }

    @Path(value="query")
    @GET
    public String queryParams(@QueryParam(value="q1") String q1, @QueryParam(value="q2") String q2) {
        return "x" + q1 + "y" + q2 + "z";
    }

    @Path(value="matrix/more")
    @GET
    public String matrixParams(@MatrixParam(value="m1") String m1, @MatrixParam(value="m2") String m2, @MatrixParam(value="m3") String m3) {
        return "w" + m1 + "x" + m2 + "y" + m3 + "z";
    }

    @Path(value="cookieParams")
    @GET
    public String cookieParams(@CookieParam(value="c1") Cookie c1, @CookieParam(value="c2") Cookie c2) {
        return "x" + this.cookieStringify(c1) + "y" + this.cookieStringify(c2) + "z";
    }

    private String cookieStringify(Cookie c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getName()).append("=").append(c.getValue()).append(";").append(c.getDomain()).append(",").append(c.getPath()).append(",").append(c.getVersion());
        return sb.toString();
    }

    @Path(value="headerParams")
    @GET
    public String headerParams(@HeaderParam(value="h1") String h1, @HeaderParam(value="h2") String h2) {
        return "x" + h1 + "y" + h2 + "z";
    }

    @Path(value="params/{p1}/list/{p1}")
    @GET
    public String paramsList(@HeaderParam(value="h1") List<String> headerList, @MatrixParam(value="m1") List<String> matrixList, @PathParam(value="p1") List<String> pathList, @QueryParam(value="q1") List<String> queryList) {
        StringBuilder sb = new StringBuilder();
        for (String s : headerList) {
            sb.append(s);
        }
        for (String s : matrixList) {
            sb.append(s);
        }
        for (String s : pathList) {
            sb.append(s);
        }
        for (String s : queryList) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Path(value="params/{p1}/set/{p1}")
    @GET
    public String paramsSet(@HeaderParam(value="h1") Set<String> headerSet, @MatrixParam(value="m1") Set<String> matrixSet, @PathParam(value="p1") Set<String> pathSet, @QueryParam(value="q1") Set<String> querySet) {
        ArrayList<String> headerList = new ArrayList<String>(headerSet);
        ArrayList<String> matrixList = new ArrayList<String>(matrixSet);
        ArrayList<String> pathList = new ArrayList<String>(pathSet);
        ArrayList<String> queryList = new ArrayList<String>(querySet);
        Collections.sort(headerList);
        Collections.sort(matrixList);
        Collections.sort(pathList);
        Collections.sort(queryList);
        StringBuilder sb = new StringBuilder();
        for (String s : headerList) {
            sb.append(s);
        }
        for (String s : matrixList) {
            sb.append(s);
        }
        for (String s : pathList) {
            sb.append(s);
        }
        for (String s : queryList) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Path(value="params/{p1}/sortedset/{p1}")
    @GET
    public String paramsSortedSet(@HeaderParam(value="h1") SortedSet<String> headerSet, @MatrixParam(value="m1") SortedSet<String> matrixSet, @PathParam(value="p1") SortedSet<String> pathSet, @QueryParam(value="q1") SortedSet<String> querySet) {
        StringBuilder sb = new StringBuilder();
        for (String s : headerSet) {
            sb.append(s);
        }
        for (String s : matrixSet) {
            sb.append(s);
        }
        for (String s : pathSet) {
            sb.append(s);
        }
        for (String s : querySet) {
            sb.append(s);
        }
        return sb.toString();
    }

    @GET
    @Path(value="suspend")
    public void suspend(final @Suspended AsyncResponse response) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Response jaxrs = Response.ok((Object)"suspend").build();
                    response.resume((Object)jaxrs);
                }
                catch (Exception e) {
                    response.resume((Throwable)e);
                }
            }
        };
        t.start();
    }

    @GET
    @Path(value="contextPath")
    public String contextPath(@Context HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        return contextPath;
    }

    @Path(value="inheritance")
    @POST
    public CC2 inheritance(CC2 cc2) {
        return new CC2("x" + cc2.s + "y", cc2.j + 1);
    }

    @Path(value="reference")
    @POST
    public CC4 referenceField(CC4 cc4) {
        CC5 newCC5 = new CC5(cc4.cc5.k + 1);
        CC4 newCC4 = new CC4("x" + cc4.s + "y", newCC5);
        return newCC4;
    }

    String m2(String s) {
        return "x";
    }

    @Path(value="m3")
    @POST
    public String m3(CC4 cc4) {
        return "x";
    }

    @Path(value="m4")
    @POST
    public boolean m4(int i) {
        return true;
    }

    @Path(value="m5")
    @GET
    public String m5() {
        return "m5";
    }

    @Path(value="m7")
    @POST
    public CC6 m7(int i) {
        CC7 cc7 = new CC7("m7", i + 1);
        CC6 cc6 = new CC6(i + 2, cc7);
        return cc6;
    }

    @Path(value="servletInfo")
    @POST
    public String testServletInfo(@Context HttpServletRequest request) {
        String characterEncoding = request.getCharacterEncoding().toUpperCase();
        Object remoteAddr = request.getRemoteAddr();
        remoteAddr = ((String)remoteAddr).substring(0, ((String)remoteAddr).lastIndexOf(".") + 1) + "5";
        String remoteHost = request.getRemoteHost().toUpperCase();
        int remotePort = request.getRemotePort() + 1;
        return characterEncoding + "|" + (String)remoteAddr + "|" + remoteHost + "|" + remotePort;
    }

    @Path(value="server/cookies")
    @GET
    public String serverCookies(@Context HttpServletResponse response) {
        jakarta.servlet.http.Cookie c1 = new jakarta.servlet.http.Cookie("n1", "v1");
        c1.setComment("c1");
        c1.setDomain("d1");
        c1.setPath("p1");
        c1.setVersion(0);
        response.addCookie(c1);
        jakarta.servlet.http.Cookie c2 = new jakarta.servlet.http.Cookie("n2", "v2");
        c2.setComment("c2");
        c2.setDomain("d2");
        c2.setMaxAge(17);
        c2.setPath("p2");
        c2.setVersion(0);
        c2.setHttpOnly(true);
        c2.setSecure(true);
        response.addCookie(c2);
        return "cookies";
    }

    @Path(value="server/headers")
    @GET
    public String serverHeaders(@Context HttpServletResponse response) {
        response.addHeader("h1", "v1a");
        response.addHeader("h1", "v1b");
        response.addHeader("h2", "v2");
        return "headers";
    }

    @Path(value="servletPath")
    @GET
    public String servletPath(@Context HttpServletRequest request) {
        return request.getContextPath() + "|" + request.getServletPath() + "|" + request.getPathInfo() + "|" + request.getPathTranslated();
    }

    @Path(value="servletParams")
    @POST
    public String servletParams(@QueryParam(value="p1") String q1, @QueryParam(value="p2") String q2, @FormParam(value="p2") String f2, @FormParam(value="p3") String f3, @Context HttpServletRequest request) {
        StringBuilder sb = new StringBuilder(q1 + "|" + q2 + "|" + f2 + "|" + f3 + "|");
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            sb.append((String)entry.getKey() + "->");
            for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                sb.append(((String[])entry.getValue())[i]);
            }
            sb.append("|");
        }
        return sb.toString();
    }

    @Path(value="jaxrsResponse")
    @GET
    public Response jaxrsResponse() {
        Response.ResponseBuilder response = Response.ok((Object)"jaxrsResponse");
        NewCookie.Builder newCookieBuilder = new NewCookie.Builder("n1");
        NewCookie newCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)newCookieBuilder.domain("d1")).path("p1")).value("v1")).maxAge(11)).expiry(new Date(111111L))).secure(false)).httpOnly(true)).build();
        response.cookie(new NewCookie[]{newCookie});
        newCookieBuilder = new NewCookie.Builder("n2");
        newCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)newCookieBuilder.value("v2")).path("p2")).domain("d2")).maxAge(17)).expiry(new Date(222222L))).secure(true)).httpOnly(false)).build();
        response.cookie(new NewCookie[]{newCookie});
        response.header("h1", (Object)"v1");
        response.status(222);
        response.type("x/y");
        return response.build();
    }

    @Path(value="servletResponse")
    @GET
    public Response servletResponse(@Context HttpServletResponse response) {
        jakarta.servlet.http.Cookie cookie = new jakarta.servlet.http.Cookie("n1", "v1");
        cookie.setDomain("d1");
        cookie.setMaxAge(3);
        cookie.setPath("p1");
        cookie.setValue("v1");
        cookie.setVersion(7);
        response.addCookie(cookie);
        response.setContentType("x/y");
        response.addDateHeader("d1", 86400000L);
        response.addHeader("h1", "v1");
        response.addIntHeader("i1", 13);
        response.setDateHeader("d2", 172800000L);
        response.setHeader("h2", "v2a");
        response.setIntHeader("i2", 19);
        response.addDateHeader("d2", 259200000L);
        response.addHeader("h2", "v2b");
        response.addIntHeader("i2", 29);
        response.addDateHeader("d3", 345600000L);
        response.addHeader("h3", "v3a");
        response.addIntHeader("i3", 37);
        response.setDateHeader("d3", 432000000L);
        response.setHeader("h3", "v3b");
        response.setIntHeader("i3", 41);
        response.setStatus(222);
        return Response.ok((Object)"servletResponse").status(223).build();
    }

    @Path(value="inner")
    @GET
    public InnerClass inner() {
        return new InnerClass();
    }

    @GET
    public String notSubresourceGet() {
        return "notSubresourceGet";
    }

    @POST
    public String notSubresourcePost() {
        return "notSubresourcePost";
    }

    @Path(value="locator")
    public Subresource locator(@Context UriInfo uriInfo) {
        return new Subresource(uriInfo);
    }

    @Path(value="servletContext")
    @GET
    public String servletContext(@Context ServletContext servletContext) {
        return servletContext.getInitParameter("resteasy.servlet.mapping.prefix");
    }

    @Path(value="servletConfig")
    @GET
    public String servletConfig(@Context ServletConfig servletConfig) {
        return servletConfig.getServletName();
    }

    @GET
    @Path(value="sse")
    @Produces(value={"text/event-stream"})
    public void sse(@Context SseEventSink eventSink, @Context Sse sse) {
        ExecutorService executor = Executors.newFixedThreadPool(3);
        Map map = ResteasyContext.getContextDataMap();
        executor.execute(() -> {
            ResteasyContext.addCloseableContextDataLevel((Map)map);
            try (SseEventSink sink = eventSink;){
                eventSink.send(sse.newEvent("name1", "event1"));
                eventSink.send(sse.newEvent("name2", "event2"));
                eventSink.send(sse.newEvent("name3", "event3"));
                OutboundSseEventImpl.BuilderImpl builder = new OutboundSseEventImpl.BuilderImpl();
                builder.name("name4").data((Object)new CC5(4));
                eventSink.send(builder.build());
            }
        });
    }

    @GET
    @Path(value="copy")
    public String copy(String s) {
        return s;
    }

    public static class Subresource {
        private String path;

        public Subresource() {
        }

        public Subresource(UriInfo uriInfo) {
            this.path = uriInfo.getPath();
        }

        @GET
        @Path(value="get")
        public String get() {
            return this.path;
        }

        @POST
        @Path(value="post/{p}")
        public String post(@PathParam(value="p") String p, String entity) {
            System.out.println("entity: '" + entity + "'");
            return p + "|" + entity;
        }
    }

    public static class InnerClass {
        private int i = 3;
        private String s = "three";

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }
}

