/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.ImageUtils;
import dev.snowdrop.buildpack.docker.VolumeBind;
import dev.snowdrop.buildpack.lifecycle.Version;
import dev.snowdrop.buildpack.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;

public class BuilderImage {
    private int DEFAULT_USER_ID = 1000;
    private int DEFAULT_GROUP_ID = 1000;
    private ImageReference image;
    private int userId;
    private int groupId;
    private boolean hasExtensions;
    private String metadataJson;
    private ImageReference runImage;
    private List<ImageReference> runImages;
    private List<String> builderSupportedPlatforms;
    private String platform;
    private DockerClient dc;

    public BuilderImage(BuilderImage original, boolean addedExtensions, ImageReference extended) {
        this.userId = original.userId;
        this.groupId = original.groupId;
        this.runImages = original.runImages;
        this.builderSupportedPlatforms = original.builderSupportedPlatforms;
        this.hasExtensions = original.hasExtensions || addedExtensions;
        this.image = extended;
        this.platform = original.platform;
        this.dc = original.dc;
    }

    public BuilderImage(DockerConfig dc, PlatformConfig pc, ImageReference runImage, ImageReference builderImage) {
        String xtnLayers;
        this.image = builderImage;
        this.dc = dc.getDockerClient();
        ImageUtils.pullImages(dc, builderImage);
        ImageUtils.ImageInfo ii = ImageUtils.inspectImage(dc.getDockerClient(), builderImage);
        this.platform = ii.platform;
        this.userId = this.DEFAULT_USER_ID;
        this.groupId = this.DEFAULT_GROUP_ID;
        for (String s : ii.env) {
            if (s.startsWith("CNB_USER_ID=")) {
                this.userId = Integer.valueOf(s.substring("CNB_USER_ID=".length()));
            }
            if (!s.startsWith("CNB_GROUP_ID=")) continue;
            this.groupId = Integer.valueOf(s.substring("CNB_GROUP_ID=".length()));
        }
        if (pc.getEnvironment().containsKey("CNB_USER_ID")) {
            this.userId = Integer.valueOf(pc.getEnvironment().get("CNB_USER_ID"));
        }
        if (pc.getEnvironment().containsKey("CNB_GROUP_ID")) {
            this.userId = Integer.valueOf(pc.getEnvironment().get("CNB_GROUP_ID"));
        }
        if ((xtnLayers = ii.labels.get("io.buildpacks.extension.layers")) != null && !xtnLayers.isEmpty()) {
            xtnLayers = xtnLayers.trim();
            xtnLayers.replaceAll("\\\\w", "");
            if (xtnLayers.equals("{}")) {
                xtnLayers = null;
            }
        }
        this.hasExtensions = xtnLayers != null && !xtnLayers.isEmpty();
        this.metadataJson = ii.labels.get("io.buildpacks.builder.metadata");
        this.runImage = runImage;
        this.runImages = null;
        this.builderSupportedPlatforms = this.getSupportedPlatformsFromMetadata();
    }

    public ImageReference getImage() {
        return this.image;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }

    public ImageReference[] getRunImages(Version activePlatformLevel) {
        if (this.runImages == null) {
            this.runImages = new ArrayList<ImageReference>();
            if (this.runImage != null) {
                this.runImages.add(this.runImage);
            } else {
                HashSet<ImageReference> runSet = new HashSet<ImageReference>();
                if (activePlatformLevel.atLeast("0.12")) {
                    runSet.addAll(this.getRunImageFromRunTOML());
                } else {
                    runSet.add(this.getRunImageFromMetadataJSON());
                }
                this.runImages.addAll(runSet);
            }
        }
        return this.runImages.toArray(new ImageReference[0]);
    }

    public void setRunImage(ImageReference runImage) {
        this.runImages = new ArrayList<ImageReference>();
        this.runImages.add(runImage);
    }

    public List<String> getBuilderSupportedPlatforms() {
        return this.builderSupportedPlatforms;
    }

    public String getImagePlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageReference> getRunImageFromRunTOML() throws BuildpackException {
        ArrayList<ImageReference> runImages = new ArrayList<ImageReference>();
        List<String> command = Stream.of("").collect(Collectors.toList());
        String builderContainerId = ContainerUtils.createContainer(this.dc, this.image.getCanonicalReference(), command, new VolumeBind[0]);
        byte[] runTomlData = new byte[]{};
        try {
            runTomlData = ContainerUtils.getFileFromContainer(this.dc, builderContainerId, "/cnb/run.toml");
        }
        finally {
            ContainerUtils.removeContainer(this.dc, builderContainerId);
        }
        TomlParseResult analyzed = Toml.parse((String)new String(runTomlData));
        TomlArray ta = analyzed.getArray("images");
        for (int i = 0; i < ta.size(); ++i) {
            runImages.add(new ImageReference(ta.getTable(i).getString("image")));
        }
        return runImages;
    }

    private ImageReference getRunImageFromMetadataJSON() throws BuildpackException {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(this.metadataJson);
            String ri = JsonUtils.getValue(root, "stack/runImage/image");
            if (ri == null) {
                throw new Exception("No runImage specified, and builderImage is missing metadata declaration");
            }
            return new ImageReference(ri);
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    private List<String> getSupportedPlatformsFromMetadata() throws BuildpackException {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonNode root = om.readTree(this.metadataJson);
            List<String> platforms = JsonUtils.getArray(root, "lifecycle/apis/platform/supported");
            if (platforms == null) {
                throw new Exception("Bad platform metadata in builder image");
            }
            return platforms;
        }
        catch (Exception e) {
            throw BuildpackException.launderThrowable(e);
        }
    }
}

