/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.CacheConfig;
import dev.snowdrop.buildpack.config.CacheConfigFluent;
import dev.snowdrop.buildpack.config.CacheConfigFluentImpl;
import dev.snowdrop.buildpack.config.EditableCacheConfig;
import java.util.Objects;

public class CacheConfigBuilder
extends CacheConfigFluentImpl<CacheConfigBuilder>
implements VisitableBuilder<CacheConfig, CacheConfigBuilder> {
    CacheConfigFluent<?> fluent;
    Boolean validationEnabled;

    public CacheConfigBuilder() {
        this(false);
    }

    public CacheConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public CacheConfigBuilder(CacheConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CacheConfigBuilder(CacheConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public CacheConfigBuilder(CacheConfigFluent<?> fluent, CacheConfig instance) {
        this(fluent, instance, false);
    }

    public CacheConfigBuilder(CacheConfigFluent<?> fluent, CacheConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCacheVolumeName(instance.getCacheVolumeName());
        fluent.withDeleteCacheAfterBuild(instance.getDeleteCacheAfterBuild());
        this.validationEnabled = validationEnabled;
    }

    public CacheConfigBuilder(CacheConfig instance) {
        this(instance, (Boolean)false);
    }

    public CacheConfigBuilder(CacheConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCacheVolumeName(instance.getCacheVolumeName());
        this.withDeleteCacheAfterBuild(instance.getDeleteCacheAfterBuild());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableCacheConfig build() {
        EditableCacheConfig buildable = new EditableCacheConfig(this.fluent.getCacheVolumeName(), this.fluent.getDeleteCacheAfterBuild());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CacheConfigBuilder that = (CacheConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

