/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import com.github.dockerjava.api.DockerClient;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.DockerConfigBuilder;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.docker.DockerClientUtils;
import java.util.ArrayList;
import java.util.List;

public class DockerConfig {
    private static final Integer DEFAULT_PULL_TIMEOUT = 60;
    private static final Integer DEFAULT_PULL_RETRY_INCREASE = 15;
    private static final Integer DEFAULT_PULL_RETRY_COUNT = 3;
    private static final PullPolicy DEFAULT_PULL_POLICY = PullPolicy.IF_NOT_PRESENT;
    private Integer pullTimeoutSeconds;
    private Integer pullRetryCount;
    private Integer pullRetryIncreaseSeconds;
    private PullPolicy pullPolicy;
    private String dockerHost;
    private String dockerSocket;
    private String dockerNetwork;
    private Boolean useDaemon;
    private DockerClient dockerClient;
    private List<RegistryAuthConfig> authConfigs;

    public static DockerConfigBuilder builder() {
        return new DockerConfigBuilder();
    }

    public DockerConfig(Integer pullTimeoutSeconds, Integer pullRetryCount, Integer pullRetryIncreaseSeconds, PullPolicy pullPolicy, String dockerHost, String dockerSocket, String dockerNetwork, Boolean useDaemon, DockerClient dockerClient, List<RegistryAuthConfig> authConfigs) {
        this.pullTimeoutSeconds = pullTimeoutSeconds != null ? Integer.max(0, pullTimeoutSeconds) : DEFAULT_PULL_TIMEOUT;
        this.pullRetryCount = pullRetryCount != null ? Integer.max(0, pullRetryCount) : DEFAULT_PULL_RETRY_COUNT;
        this.pullRetryIncreaseSeconds = pullRetryIncreaseSeconds != null ? Integer.max(0, pullRetryIncreaseSeconds) : DEFAULT_PULL_RETRY_INCREASE;
        this.pullPolicy = pullPolicy != null ? pullPolicy : DEFAULT_PULL_POLICY;
        this.dockerNetwork = dockerNetwork;
        this.useDaemon = useDaemon != null ? useDaemon : Boolean.TRUE;
        DockerClientUtils.HostAndSocket hands = DockerClientUtils.probeContainerRuntime(new DockerClientUtils.HostAndSocket(dockerHost, dockerSocket));
        this.dockerHost = hands.host;
        this.dockerSocket = hands.socket;
        this.authConfigs = authConfigs == null ? new ArrayList<RegistryAuthConfig>() : authConfigs;
        this.dockerClient = dockerClient != null ? dockerClient : DockerClientUtils.getDockerClient(hands, authConfigs);
        try {
            this.dockerClient.pingCmd().exec();
        }
        catch (Exception e) {
            throw new BuildpackException("Unable to verify docker settings", e);
        }
    }

    public void setDockerHost(String dockerHost) {
        DockerClientUtils.HostAndSocket hands = DockerClientUtils.probeContainerRuntime(new DockerClientUtils.HostAndSocket(dockerHost, this.dockerSocket));
        this.dockerHost = hands.host;
        this.dockerSocket = hands.socket;
        this.dockerClient = this.dockerClient != null ? this.dockerClient : DockerClientUtils.getDockerClient(hands);
    }

    public void setDockerSocket(String dockerSocket) {
        DockerClientUtils.HostAndSocket hands = DockerClientUtils.probeContainerRuntime(new DockerClientUtils.HostAndSocket(this.dockerHost, dockerSocket));
        this.dockerHost = hands.host;
        this.dockerSocket = hands.socket;
        this.dockerClient = this.dockerClient != null ? this.dockerClient : DockerClientUtils.getDockerClient(hands);
    }

    public Integer getPullTimeoutSeconds() {
        return this.pullTimeoutSeconds;
    }

    public Integer getPullRetryCount() {
        return this.pullRetryCount;
    }

    public Integer getPullRetryIncreaseSeconds() {
        return this.pullRetryIncreaseSeconds;
    }

    public PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public String getDockerSocket() {
        return this.dockerSocket;
    }

    public String getDockerNetwork() {
        return this.dockerNetwork;
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    public Boolean getUseDaemon() {
        return this.useDaemon;
    }

    public List<RegistryAuthConfig> getAuthConfigs() {
        return this.authConfigs;
    }

    public static enum PullPolicy {
        ALWAYS,
        IF_NOT_PRESENT,
        NEVER;

    }
}

