/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.DockerConfigFluent;
import dev.snowdrop.buildpack.config.DockerConfigFluentImpl;
import dev.snowdrop.buildpack.config.EditableDockerConfig;
import java.util.Objects;

public class DockerConfigBuilder
extends DockerConfigFluentImpl<DockerConfigBuilder>
implements VisitableBuilder<DockerConfig, DockerConfigBuilder> {
    DockerConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DockerConfigBuilder() {
        this(false);
    }

    public DockerConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public DockerConfigBuilder(DockerConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DockerConfigBuilder(DockerConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public DockerConfigBuilder(DockerConfigFluent<?> fluent, DockerConfig instance) {
        this(fluent, instance, false);
    }

    public DockerConfigBuilder(DockerConfigFluent<?> fluent, DockerConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        fluent.withPullRetryCount(instance.getPullRetryCount());
        fluent.withPullRetryIncreaseSeconds(instance.getPullRetryIncreaseSeconds());
        fluent.withPullPolicy(instance.getPullPolicy());
        fluent.withDockerHost(instance.getDockerHost());
        fluent.withDockerSocket(instance.getDockerSocket());
        fluent.withDockerNetwork(instance.getDockerNetwork());
        fluent.withUseDaemon(instance.getUseDaemon());
        fluent.withDockerClient(instance.getDockerClient());
        fluent.withAuthConfigs(instance.getAuthConfigs());
        this.validationEnabled = validationEnabled;
    }

    public DockerConfigBuilder(DockerConfig instance) {
        this(instance, (Boolean)false);
    }

    public DockerConfigBuilder(DockerConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        this.withPullRetryCount(instance.getPullRetryCount());
        this.withPullRetryIncreaseSeconds(instance.getPullRetryIncreaseSeconds());
        this.withPullPolicy(instance.getPullPolicy());
        this.withDockerHost(instance.getDockerHost());
        this.withDockerSocket(instance.getDockerSocket());
        this.withDockerNetwork(instance.getDockerNetwork());
        this.withUseDaemon(instance.getUseDaemon());
        this.withDockerClient(instance.getDockerClient());
        this.withAuthConfigs(instance.getAuthConfigs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableDockerConfig build() {
        EditableDockerConfig buildable = new EditableDockerConfig(this.fluent.getPullTimeoutSeconds(), this.fluent.getPullRetryCount(), this.fluent.getPullRetryIncreaseSeconds(), this.fluent.getPullPolicy(), this.fluent.getDockerHost(), this.fluent.getDockerSocket(), this.fluent.getDockerNetwork(), this.fluent.getUseDaemon(), this.fluent.getDockerClient(), this.fluent.getAuthConfigs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerConfigBuilder that = (DockerConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

