/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import com.github.dockerjava.api.DockerClient;
import dev.snowdrop.buildpack.builder.BaseFluent;
import dev.snowdrop.buildpack.builder.Nested;
import dev.snowdrop.buildpack.config.DockerConfig;
import dev.snowdrop.buildpack.config.DockerConfigFluent;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfigBuilder;
import dev.snowdrop.buildpack.config.RegistryAuthConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DockerConfigFluentImpl<A extends DockerConfigFluent<A>>
extends BaseFluent<A>
implements DockerConfigFluent<A> {
    private Integer pullTimeoutSeconds;
    private Integer pullRetryCount;
    private Integer pullRetryIncreaseSeconds;
    private DockerConfig.PullPolicy pullPolicy;
    private String dockerHost;
    private String dockerSocket;
    private String dockerNetwork;
    private Boolean useDaemon;
    private DockerClient dockerClient;
    private ArrayList<RegistryAuthConfigBuilder> authConfigs;

    public DockerConfigFluentImpl() {
    }

    public DockerConfigFluentImpl(DockerConfig instance) {
        this.withPullTimeoutSeconds(instance.getPullTimeoutSeconds());
        this.withPullRetryCount(instance.getPullRetryCount());
        this.withPullRetryIncreaseSeconds(instance.getPullRetryIncreaseSeconds());
        this.withPullPolicy(instance.getPullPolicy());
        this.withDockerHost(instance.getDockerHost());
        this.withDockerSocket(instance.getDockerSocket());
        this.withDockerNetwork(instance.getDockerNetwork());
        this.withUseDaemon(instance.getUseDaemon());
        this.withDockerClient(instance.getDockerClient());
        this.withAuthConfigs(instance.getAuthConfigs());
    }

    @Override
    public Integer getPullTimeoutSeconds() {
        return this.pullTimeoutSeconds;
    }

    @Override
    public A withPullTimeoutSeconds(Integer pullTimeoutSeconds) {
        this.pullTimeoutSeconds = pullTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasPullTimeoutSeconds() {
        return this.pullTimeoutSeconds != null;
    }

    @Override
    public Integer getPullRetryCount() {
        return this.pullRetryCount;
    }

    @Override
    public A withPullRetryCount(Integer pullRetryCount) {
        this.pullRetryCount = pullRetryCount;
        return (A)this;
    }

    @Override
    public Boolean hasPullRetryCount() {
        return this.pullRetryCount != null;
    }

    @Override
    public Integer getPullRetryIncreaseSeconds() {
        return this.pullRetryIncreaseSeconds;
    }

    @Override
    public A withPullRetryIncreaseSeconds(Integer pullRetryIncreaseSeconds) {
        this.pullRetryIncreaseSeconds = pullRetryIncreaseSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasPullRetryIncreaseSeconds() {
        return this.pullRetryIncreaseSeconds != null;
    }

    @Override
    public DockerConfig.PullPolicy getPullPolicy() {
        return this.pullPolicy;
    }

    @Override
    public A withPullPolicy(DockerConfig.PullPolicy pullPolicy) {
        this.pullPolicy = pullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPullPolicy() {
        return this.pullPolicy != null;
    }

    @Override
    public String getDockerHost() {
        return this.dockerHost;
    }

    @Override
    public A withDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
        return (A)this;
    }

    @Override
    public Boolean hasDockerHost() {
        return this.dockerHost != null;
    }

    @Override
    public String getDockerSocket() {
        return this.dockerSocket;
    }

    @Override
    public A withDockerSocket(String dockerSocket) {
        this.dockerSocket = dockerSocket;
        return (A)this;
    }

    @Override
    public Boolean hasDockerSocket() {
        return this.dockerSocket != null;
    }

    @Override
    public String getDockerNetwork() {
        return this.dockerNetwork;
    }

    @Override
    public A withDockerNetwork(String dockerNetwork) {
        this.dockerNetwork = dockerNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasDockerNetwork() {
        return this.dockerNetwork != null;
    }

    @Override
    public Boolean getUseDaemon() {
        return this.useDaemon;
    }

    @Override
    public A withUseDaemon(Boolean useDaemon) {
        this.useDaemon = useDaemon;
        return (A)this;
    }

    @Override
    public Boolean hasUseDaemon() {
        return this.useDaemon != null;
    }

    @Override
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Override
    public A withDockerClient(DockerClient dockerClient) {
        this.dockerClient = dockerClient;
        return (A)this;
    }

    @Override
    public Boolean hasDockerClient() {
        return this.dockerClient != null;
    }

    @Override
    public A addToAuthConfigs(Integer index, RegistryAuthConfig item) {
        if (this.authConfigs == null) {
            this.authConfigs = new ArrayList();
        }
        RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
        this._visitables.get("authConfigs").add(index >= 0 ? index.intValue() : this._visitables.get("authConfigs").size(), builder);
        this.authConfigs.add(index >= 0 ? index.intValue() : this.authConfigs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAuthConfigs(Integer index, RegistryAuthConfig item) {
        if (this.authConfigs == null) {
            this.authConfigs = new ArrayList();
        }
        RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get("authConfigs").size()) {
            this._visitables.get("authConfigs").add(builder);
        } else {
            this._visitables.get("authConfigs").set(index, builder);
        }
        if (index < 0 || index >= this.authConfigs.size()) {
            this.authConfigs.add(builder);
        } else {
            this.authConfigs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAuthConfigs(RegistryAuthConfig ... items) {
        if (this.authConfigs == null) {
            this.authConfigs = new ArrayList();
        }
        for (RegistryAuthConfig item : items) {
            RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
            this._visitables.get("authConfigs").add(builder);
            this.authConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAuthConfigs(Collection<RegistryAuthConfig> items) {
        if (this.authConfigs == null) {
            this.authConfigs = new ArrayList();
        }
        for (RegistryAuthConfig item : items) {
            RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
            this._visitables.get("authConfigs").add(builder);
            this.authConfigs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuthConfigs(RegistryAuthConfig ... items) {
        for (RegistryAuthConfig item : items) {
            RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
            this._visitables.get("authConfigs").remove(builder);
            if (this.authConfigs == null) continue;
            this.authConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAuthConfigs(Collection<RegistryAuthConfig> items) {
        for (RegistryAuthConfig item : items) {
            RegistryAuthConfigBuilder builder = new RegistryAuthConfigBuilder(item);
            this._visitables.get("authConfigs").remove(builder);
            if (this.authConfigs == null) continue;
            this.authConfigs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAuthConfigs(Predicate<RegistryAuthConfigBuilder> predicate) {
        if (this.authConfigs == null) {
            return (A)this;
        }
        Iterator<RegistryAuthConfigBuilder> each = this.authConfigs.iterator();
        Object visitables = this._visitables.get("authConfigs");
        while (each.hasNext()) {
            RegistryAuthConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RegistryAuthConfig> getAuthConfigs() {
        return this.authConfigs != null ? DockerConfigFluentImpl.build(this.authConfigs) : null;
    }

    @Override
    public List<RegistryAuthConfig> buildAuthConfigs() {
        return this.authConfigs != null ? DockerConfigFluentImpl.build(this.authConfigs) : null;
    }

    @Override
    public RegistryAuthConfig buildAuthConfig(Integer index) {
        return this.authConfigs.get(index).build();
    }

    @Override
    public RegistryAuthConfig buildFirstAuthConfig() {
        return this.authConfigs.get(0).build();
    }

    @Override
    public RegistryAuthConfig buildLastAuthConfig() {
        return this.authConfigs.get(this.authConfigs.size() - 1).build();
    }

    @Override
    public RegistryAuthConfig buildMatchingAuthConfig(Predicate<RegistryAuthConfigBuilder> predicate) {
        for (RegistryAuthConfigBuilder item : this.authConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAuthConfig(Predicate<RegistryAuthConfigBuilder> predicate) {
        for (RegistryAuthConfigBuilder item : this.authConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAuthConfigs(List<RegistryAuthConfig> authConfigs) {
        if (this.authConfigs != null) {
            this._visitables.get("authConfigs").removeAll(this.authConfigs);
        }
        if (authConfigs != null) {
            this.authConfigs = new ArrayList();
            for (RegistryAuthConfig item : authConfigs) {
                this.addToAuthConfigs(item);
            }
        } else {
            this.authConfigs = null;
        }
        return (A)this;
    }

    @Override
    public A withAuthConfigs(RegistryAuthConfig ... authConfigs) {
        if (this.authConfigs != null) {
            this.authConfigs.clear();
        }
        if (authConfigs != null) {
            for (RegistryAuthConfig item : authConfigs) {
                this.addToAuthConfigs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthConfigs() {
        return this.authConfigs != null && !this.authConfigs.isEmpty();
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> addNewAuthConfig() {
        return new AuthConfigsNestedImpl();
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> addNewAuthConfigLike(RegistryAuthConfig item) {
        return new AuthConfigsNestedImpl(-1, item);
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> setNewAuthConfigLike(Integer index, RegistryAuthConfig item) {
        return new AuthConfigsNestedImpl(index, item);
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> editAuthConfig(Integer index) {
        if (this.authConfigs.size() <= index) {
            throw new RuntimeException("Can't edit authConfigs. Index exceeds size.");
        }
        return this.setNewAuthConfigLike(index, this.buildAuthConfig(index));
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> editFirstAuthConfig() {
        if (this.authConfigs.size() == 0) {
            throw new RuntimeException("Can't edit first authConfigs. The list is empty.");
        }
        return this.setNewAuthConfigLike(0, this.buildAuthConfig(0));
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> editLastAuthConfig() {
        int index = this.authConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last authConfigs. The list is empty.");
        }
        return this.setNewAuthConfigLike(index, this.buildAuthConfig(index));
    }

    @Override
    public DockerConfigFluent.AuthConfigsNested<A> editMatchingAuthConfig(Predicate<RegistryAuthConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.authConfigs.size(); ++i) {
            if (!predicate.test(this.authConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching authConfigs. No match found.");
        }
        return this.setNewAuthConfigLike(index, this.buildAuthConfig(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerConfigFluentImpl that = (DockerConfigFluentImpl)o;
        if (this.pullTimeoutSeconds != null ? !this.pullTimeoutSeconds.equals(that.pullTimeoutSeconds) : that.pullTimeoutSeconds != null) {
            return false;
        }
        if (this.pullRetryCount != null ? !this.pullRetryCount.equals(that.pullRetryCount) : that.pullRetryCount != null) {
            return false;
        }
        if (this.pullRetryIncreaseSeconds != null ? !this.pullRetryIncreaseSeconds.equals(that.pullRetryIncreaseSeconds) : that.pullRetryIncreaseSeconds != null) {
            return false;
        }
        if (this.pullPolicy != null ? !this.pullPolicy.equals((Object)that.pullPolicy) : that.pullPolicy != null) {
            return false;
        }
        if (this.dockerHost != null ? !this.dockerHost.equals(that.dockerHost) : that.dockerHost != null) {
            return false;
        }
        if (this.dockerSocket != null ? !this.dockerSocket.equals(that.dockerSocket) : that.dockerSocket != null) {
            return false;
        }
        if (this.dockerNetwork != null ? !this.dockerNetwork.equals(that.dockerNetwork) : that.dockerNetwork != null) {
            return false;
        }
        if (this.useDaemon != null ? !this.useDaemon.equals(that.useDaemon) : that.useDaemon != null) {
            return false;
        }
        if (this.dockerClient != null ? !this.dockerClient.equals(that.dockerClient) : that.dockerClient != null) {
            return false;
        }
        return !(this.authConfigs != null ? !this.authConfigs.equals(that.authConfigs) : that.authConfigs != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pullTimeoutSeconds, this.pullRetryCount, this.pullRetryIncreaseSeconds, this.pullPolicy, this.dockerHost, this.dockerSocket, this.dockerNetwork, this.useDaemon, this.dockerClient, this.authConfigs, super.hashCode()});
    }

    public class AuthConfigsNestedImpl<N>
    extends RegistryAuthConfigFluentImpl<DockerConfigFluent.AuthConfigsNested<N>>
    implements DockerConfigFluent.AuthConfigsNested<N>,
    Nested<N> {
        RegistryAuthConfigBuilder builder;
        Integer index;

        AuthConfigsNestedImpl(Integer index, RegistryAuthConfig item) {
            this.index = index;
            this.builder = new RegistryAuthConfigBuilder(this, item);
        }

        AuthConfigsNestedImpl() {
            this.index = -1;
            this.builder = new RegistryAuthConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerConfigFluentImpl.this.setToAuthConfigs(this.index, this.builder.build());
        }

        @Override
        public N endAuthConfig() {
            return this.and();
        }
    }
}

