/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.EditableLogConfig;
import dev.snowdrop.buildpack.config.LogConfig;
import dev.snowdrop.buildpack.config.LogConfigFluent;
import dev.snowdrop.buildpack.config.LogConfigFluentImpl;
import java.util.Objects;

public class LogConfigBuilder
extends LogConfigFluentImpl<LogConfigBuilder>
implements VisitableBuilder<LogConfig, LogConfigBuilder> {
    LogConfigFluent<?> fluent;
    Boolean validationEnabled;

    public LogConfigBuilder() {
        this(false);
    }

    public LogConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, LogConfig instance) {
        this(fluent, instance, false);
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, LogConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withUseTimestamps(instance.getUseTimestamps());
        fluent.withLogger(instance.getLogger());
        this.validationEnabled = validationEnabled;
    }

    public LogConfigBuilder(LogConfig instance) {
        this(instance, (Boolean)false);
    }

    public LogConfigBuilder(LogConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLogLevel(instance.getLogLevel());
        this.withUseTimestamps(instance.getUseTimestamps());
        this.withLogger(instance.getLogger());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableLogConfig build() {
        EditableLogConfig buildable = new EditableLogConfig(this.fluent.getLogLevel(), this.fluent.getUseTimestamps(), this.fluent.getLogger());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogConfigBuilder that = (LogConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

