/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.Slf4jLogger;
import dev.snowdrop.buildpack.Slf4jLoggerBuilder;
import dev.snowdrop.buildpack.Slf4jLoggerFluentImpl;
import dev.snowdrop.buildpack.SystemLogger;
import dev.snowdrop.buildpack.SystemLoggerBuilder;
import dev.snowdrop.buildpack.SystemLoggerFluentImpl;
import dev.snowdrop.buildpack.builder.BaseFluent;
import dev.snowdrop.buildpack.builder.Nested;
import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.LogConfig;
import dev.snowdrop.buildpack.config.LogConfigFluent;
import java.util.Objects;

public class LogConfigFluentImpl<A extends LogConfigFluent<A>>
extends BaseFluent<A>
implements LogConfigFluent<A> {
    private String logLevel;
    private Boolean useTimestamps;
    private VisitableBuilder<? extends Logger, ?> logger;

    public LogConfigFluentImpl() {
    }

    public LogConfigFluentImpl(LogConfig instance) {
        this.withLogLevel(instance.getLogLevel());
        this.withUseTimestamps(instance.getUseTimestamps());
        this.withLogger(instance.getLogger());
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public Boolean getUseTimestamps() {
        return this.useTimestamps;
    }

    @Override
    public A withUseTimestamps(Boolean useTimestamps) {
        this.useTimestamps = useTimestamps;
        return (A)this;
    }

    @Override
    public Boolean hasUseTimestamps() {
        return this.useTimestamps != null;
    }

    @Override
    @Deprecated
    public Logger getLogger() {
        return this.logger != null ? (Logger)this.logger.build() : null;
    }

    @Override
    public Logger buildLogger() {
        return this.logger != null ? (Logger)this.logger.build() : null;
    }

    @Override
    public A withLogger(Logger logger) {
        if (logger instanceof SystemLogger) {
            this.logger = new SystemLoggerBuilder((SystemLogger)logger);
            this._visitables.get("logger").add(this.logger);
        }
        if (logger instanceof Slf4jLogger) {
            this.logger = new Slf4jLoggerBuilder((Slf4jLogger)logger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogger() {
        return this.logger != null;
    }

    @Override
    public A withSystemLogger(SystemLogger systemLogger) {
        this._visitables.get("logger").remove(this.logger);
        if (systemLogger != null) {
            this.logger = new SystemLoggerBuilder(systemLogger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public LogConfigFluent.SystemLoggerNested<A> withNewSystemLogger() {
        return new SystemLoggerNestedImpl();
    }

    @Override
    public LogConfigFluent.SystemLoggerNested<A> withNewSystemLoggerLike(SystemLogger item) {
        return new SystemLoggerNestedImpl(item);
    }

    @Override
    public A withNewSystemLogger(boolean ansiColorEnabled) {
        return this.withSystemLogger(new SystemLogger(ansiColorEnabled));
    }

    @Override
    public A withSlf4jLogger(Slf4jLogger slf4jLogger) {
        this._visitables.get("logger").remove(this.logger);
        if (slf4jLogger != null) {
            this.logger = new Slf4jLoggerBuilder(slf4jLogger);
            this._visitables.get("logger").add(this.logger);
        }
        return (A)this;
    }

    @Override
    public LogConfigFluent.Slf4jLoggerNested<A> withNewSlf4jLogger() {
        return new Slf4jLoggerNestedImpl();
    }

    @Override
    public LogConfigFluent.Slf4jLoggerNested<A> withNewSlf4jLoggerLike(Slf4jLogger item) {
        return new Slf4jLoggerNestedImpl(item);
    }

    @Override
    public A withNewSlf4jLogger(String name) {
        return this.withSlf4jLogger(new Slf4jLogger(name));
    }

    @Override
    public A withNewSlf4jLogger(Class c) {
        return this.withSlf4jLogger(new Slf4jLogger(c));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogConfigFluentImpl that = (LogConfigFluentImpl)o;
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.useTimestamps != null ? !this.useTimestamps.equals(that.useTimestamps) : that.useTimestamps != null) {
            return false;
        }
        return !(this.logger != null ? !this.logger.equals(that.logger) : that.logger != null);
    }

    public int hashCode() {
        return Objects.hash(this.logLevel, this.useTimestamps, this.logger, super.hashCode());
    }

    public class SystemLoggerNestedImpl<N>
    extends SystemLoggerFluentImpl<LogConfigFluent.SystemLoggerNested<N>>
    implements LogConfigFluent.SystemLoggerNested<N>,
    Nested<N> {
        SystemLoggerBuilder builder;

        SystemLoggerNestedImpl(SystemLogger item) {
            this.builder = new SystemLoggerBuilder(this, item);
        }

        SystemLoggerNestedImpl() {
            this.builder = new SystemLoggerBuilder(this);
        }

        @Override
        public N and() {
            return (N)LogConfigFluentImpl.this.withLogger(this.builder.build());
        }

        @Override
        public N endSystemLogger() {
            return this.and();
        }
    }

    public class Slf4jLoggerNestedImpl<N>
    extends Slf4jLoggerFluentImpl<LogConfigFluent.Slf4jLoggerNested<N>>
    implements LogConfigFluent.Slf4jLoggerNested<N>,
    Nested<N> {
        Slf4jLoggerBuilder builder;

        Slf4jLoggerNestedImpl(Slf4jLogger item) {
            this.builder = new Slf4jLoggerBuilder(this, item);
        }

        Slf4jLoggerNestedImpl() {
            this.builder = new Slf4jLoggerBuilder(this);
        }

        @Override
        public N and() {
            return (N)LogConfigFluentImpl.this.withLogger(this.builder.build());
        }

        @Override
        public N endSlf4jLogger() {
            return this.and();
        }
    }
}

