/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.EditablePlatformConfig;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.config.PlatformConfigFluent;
import dev.snowdrop.buildpack.config.PlatformConfigFluentImpl;
import java.util.Objects;

public class PlatformConfigBuilder
extends PlatformConfigFluentImpl<PlatformConfigBuilder>
implements VisitableBuilder<PlatformConfig, PlatformConfigBuilder> {
    PlatformConfigFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformConfigBuilder() {
        this(false);
    }

    public PlatformConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public PlatformConfigBuilder(PlatformConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformConfigBuilder(PlatformConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public PlatformConfigBuilder(PlatformConfigFluent<?> fluent, PlatformConfig instance) {
        this(fluent, instance, false);
    }

    public PlatformConfigBuilder(PlatformConfigFluent<?> fluent, PlatformConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPlatformLevel(instance.getPlatformLevel());
        fluent.withLifecycleImage(instance.getLifecycleImage());
        fluent.withEnvironment(instance.getEnvironment());
        fluent.withTrustBuilder(instance.getTrustBuilder());
        fluent.withPhaseDebugScript(instance.getPhaseDebugScript());
        this.validationEnabled = validationEnabled;
    }

    public PlatformConfigBuilder(PlatformConfig instance) {
        this(instance, (Boolean)false);
    }

    public PlatformConfigBuilder(PlatformConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPlatformLevel(instance.getPlatformLevel());
        this.withLifecycleImage(instance.getLifecycleImage());
        this.withEnvironment(instance.getEnvironment());
        this.withTrustBuilder(instance.getTrustBuilder());
        this.withPhaseDebugScript(instance.getPhaseDebugScript());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditablePlatformConfig build() {
        EditablePlatformConfig buildable = new EditablePlatformConfig(this.fluent.getPlatformLevel(), this.fluent.getLifecycleImage(), this.fluent.getEnvironment(), this.fluent.getTrustBuilder(), this.fluent.getPhaseDebugScript());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformConfigBuilder that = (PlatformConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

