/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.config;

import dev.snowdrop.buildpack.builder.VisitableBuilder;
import dev.snowdrop.buildpack.config.EditableRegistryAuthConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfigFluent;
import dev.snowdrop.buildpack.config.RegistryAuthConfigFluentImpl;
import java.util.Objects;

public class RegistryAuthConfigBuilder
extends RegistryAuthConfigFluentImpl<RegistryAuthConfigBuilder>
implements VisitableBuilder<RegistryAuthConfig, RegistryAuthConfigBuilder> {
    RegistryAuthConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RegistryAuthConfigBuilder() {
        this(false);
    }

    public RegistryAuthConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfigFluent<?> fluent, RegistryAuthConfig instance) {
        this(fluent, instance, false);
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfigFluent<?> fluent, RegistryAuthConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRegistryAddress(instance.getRegistryAddress());
        fluent.withRegistryToken(instance.getRegistryToken());
        fluent.withUsername(instance.getUsername());
        fluent.withAuth(instance.getAuth());
        fluent.withEmail(instance.getEmail());
        fluent.withIdentityToken(instance.getIdentityToken());
        fluent.withPassword(instance.getPassword());
        this.validationEnabled = validationEnabled;
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfig instance) {
        this(instance, (Boolean)false);
    }

    public RegistryAuthConfigBuilder(RegistryAuthConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRegistryAddress(instance.getRegistryAddress());
        this.withRegistryToken(instance.getRegistryToken());
        this.withUsername(instance.getUsername());
        this.withAuth(instance.getAuth());
        this.withEmail(instance.getEmail());
        this.withIdentityToken(instance.getIdentityToken());
        this.withPassword(instance.getPassword());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableRegistryAuthConfig build() {
        EditableRegistryAuthConfig buildable = new EditableRegistryAuthConfig(this.fluent.getRegistryAddress(), this.fluent.getRegistryToken(), this.fluent.getUsername(), this.fluent.getAuth(), this.fluent.getEmail(), this.fluent.getIdentityToken(), this.fluent.getPassword());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistryAuthConfigBuilder that = (RegistryAuthConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

