/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientConfigDelegate;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthDelegatingDockerClientConfig
extends DockerClientConfigDelegate {
    private static final Logger log = LoggerFactory.getLogger(AuthDelegatingDockerClientConfig.class);
    private List<RegistryAuthConfig> registryAuthInfo;

    public AuthDelegatingDockerClientConfig(DockerClientConfig delegate) {
        super(delegate);
    }

    public void setRegistryAuthConfigs(List<RegistryAuthConfig> registryAuthInfo) {
        this.registryAuthInfo = registryAuthInfo;
    }

    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig fallbackAuthConfig;
        log.debug("Resolving authentication configuration for image " + imageName);
        try {
            fallbackAuthConfig = super.effectiveAuthConfig(imageName);
            log.debug("fallback config retrieved");
        }
        catch (Exception e) {
            fallbackAuthConfig = new AuthConfig();
            log.debug("no fallback config available");
        }
        ImageReference parsed = new ImageReference(imageName);
        String address = parsed.getPort() != null ? parsed.getHost() + ":" + parsed.getPort() : parsed.getHost();
        log.debug("Checking configuration for auth config for address " + address);
        if (this.registryAuthInfo != null) {
            for (RegistryAuthConfig rac : this.registryAuthInfo) {
                if (!address.equals(rac.getRegistryAddress())) continue;
                log.debug("found match, configuring");
                return new AuthConfig().withAuth(rac.getAuth()).withEmail(rac.getEmail()).withIdentityToken(rac.getIdentityToken()).withPassword(rac.getPassword()).withRegistryAddress(rac.getRegistryAddress()).withRegistrytoken(rac.getRegistryToken()).withUsername(rac.getUsername());
            }
        }
        log.debug("no match, using fallback if available");
        return fallbackAuthConfig;
    }
}

