/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import dev.snowdrop.buildpack.BuilderImage;
import dev.snowdrop.buildpack.BuildpackException;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.PlatformConfig;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.VolumeBind;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildContainerUtils {
    private static final Logger log = LoggerFactory.getLogger(BuildContainerUtils.class);

    private static InputStream getArchiveStreamFromContainer(DockerClient dc, String containerId, String path) {
        CopyArchiveFromContainerCmd copyLifecyleFromImageCmd = dc.copyArchiveFromContainerCmd(containerId, path);
        try {
            return copyLifecyleFromImageCmd.exec();
        }
        catch (NotFoundException nfe) {
            throw BuildpackException.launderThrowable("Unable to locate container '" + containerId + "'", nfe);
        }
    }

    private static void putArchiveStreamToContainer(DockerClient dc, String containerId, String atPath, InputStream tarStream) {
        dc.copyArchiveToContainerCmd(containerId).withTarInputStream(tarStream).withRemotePath(atPath).exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBuildModule(DockerClient dc, String targetContainerId, String moduleImageReference, String fromPath, String toPath) {
        String containerId = null;
        List<String> command = Stream.of("").collect(Collectors.toList());
        try {
            containerId = ContainerUtils.createContainer(dc, moduleImageReference, command, new VolumeBind[0]);
            InputStream stream = BuildContainerUtils.getArchiveStreamFromContainer(dc, containerId, fromPath);
            BuildContainerUtils.putArchiveStreamToContainer(dc, targetContainerId, toPath, stream);
        }
        finally {
            if (containerId != null) {
                ContainerUtils.removeContainer(dc, containerId);
            }
        }
    }

    private static void populateMountPointDirs(final DockerClient dc, final String targetContainerId, final int uid, final int gid, final List<String> dirs) {
        try (final PipedInputStream in = new PipedInputStream(4096);
             final PipedOutputStream out = new PipedOutputStream(in);){
            final AtomicReference writerException = new AtomicReference();
            Runnable writer = new Runnable(){

                @Override
                public void run() {
                    try (TarArchiveOutputStream tout = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(out)));){
                        tout.setLongFileMode(3);
                        for (String dir : dirs) {
                            TarArchiveEntry tae = new TarArchiveEntry(dir + "/");
                            tae.setSize(0L);
                            tae.setUserId(uid);
                            tae.setGroupId(gid);
                            tae.setMode(16877);
                            tout.putArchiveEntry((ArchiveEntry)tae);
                            tout.closeArchiveEntry();
                        }
                    }
                    catch (Exception e) {
                        writerException.set(e);
                    }
                }
            };
            Runnable reader = new Runnable(){

                @Override
                public void run() {
                    dc.copyArchiveToContainerCmd(targetContainerId).withRemotePath("/").withTarInputStream((InputStream)in).exec();
                }
            };
            Thread t1 = new Thread(writer);
            Thread t2 = new Thread(reader);
            t1.start();
            t2.start();
            try {
                t1.join();
                t2.join();
            }
            catch (InterruptedException ie) {
                throw BuildpackException.launderThrowable(ie);
            }
            Exception wio = (Exception)writerException.get();
            if (wio != null) {
                throw BuildpackException.launderThrowable(wio);
            }
        }
        catch (IOException e) {
            throw BuildpackException.launderThrowable(e);
        }
    }

    private static void addDebug(DockerClient dc, PlatformConfig pc, String targetContainerId) {
        if (pc.getPhaseDebugScript() != null || System.getenv("DEBUG_LIFECYCLE") != null || System.getProperty("DEBUG_LIFECYCLE") != null) {
            String defaultDebugScript = "#!/bin/bash\necho \"DEBUG INFO\"\nstat -c \"%A $a %u %g %n\" /*\nLC=$1\nshift\n$LC \"$@\"";
            String script = pc.getPhaseDebugScript() == null ? defaultDebugScript : pc.getPhaseDebugScript();
            ContainerUtils.addContentToContainer(dc, targetContainerId, "/cnb/lifecycle", (Integer)1002, (Integer)1000, "debug", 493, script);
            System.setProperty("DEBUG_LIFECYCLE", "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuilderImage createBuildImage(DockerClient dc, PlatformConfig pc, BuilderImage baseBuilder, ImageReference lifecycle, List<ImageReference> extensions, List<ImageReference> buildpacks) {
        log.debug("Creating Ephemeral image, from " + baseBuilder.getImage().getCanonicalReference() + " with uid:gid " + baseBuilder.getUserId() + ":" + baseBuilder.getGroupId());
        List<String> command = Stream.of("").collect(Collectors.toList());
        String builderContainerId = ContainerUtils.createContainer(dc, baseBuilder.getImage().getCanonicalReference(), command, new VolumeBind[0]);
        try {
            if (lifecycle != null) {
                BuildContainerUtils.processBuildModule(dc, builderContainerId, lifecycle.getCanonicalReference(), "/cnb/lifecycle", "/cnb");
            }
            if (extensions != null) {
                for (ImageReference extension : extensions) {
                    BuildContainerUtils.processBuildModule(dc, builderContainerId, extension.getCanonicalReference(), "/cnb/extensions", "/cnb");
                }
            }
            if (buildpacks != null) {
                for (ImageReference buildpack : buildpacks) {
                    BuildContainerUtils.processBuildModule(dc, builderContainerId, buildpack.getCanonicalReference(), "/cnb/buildpacks", "/cnb");
                }
            }
            BuildContainerUtils.populateMountPointDirs(dc, builderContainerId, baseBuilder.getUserId(), baseBuilder.getGroupId(), Stream.of("/kaniko", "/workspace", "/layers", "/cache-dir", "/launch-cache-dir", "/platform", "/platform").collect(Collectors.toList()));
            BuildContainerUtils.addDebug(dc, pc, builderContainerId);
            String ephemeralBuilderImageId = ContainerUtils.commitContainer(dc, builderContainerId);
            String name = "buildpack-ephemeralbuilder-" + new Random().ints(97, 123).limit(8L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            log.debug("Ephemeral Builder created with ID " + ephemeralBuilderImageId + " tagging with friendly name " + name + " for build ");
            dc.tagImageCmd(ephemeralBuilderImageId, "docker.io/" + name, "latest").exec();
            BuilderImage builderImage = new BuilderImage(baseBuilder, extensions != null && !extensions.isEmpty(), new ImageReference(name));
            return builderImage;
        }
        finally {
            if (builderContainerId != null) {
                ContainerUtils.removeContainer(dc, builderContainerId);
            }
        }
    }
}

