/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.docker.AuthDelegatingDockerClientConfig;
import dev.snowdrop.buildpack.utils.OperatingSytem;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientUtils.class);
    private static final String[] MAC_PODMAN_HOST = new String[]{"podman", "machine", "inspect", "--format", "unix://{{.ConnectionInfo.PodmanSocket.Path}}"};
    private static final String[] LIN_PODMAN_HOST = new String[]{"podman", "info", "--format", "unix://{{.Host.RemoteSocket.Path}}"};
    private static final String[] WIN_PODMAN_HOST = new String[]{"podman", "machine", "inspect", "--format", "npipe://{{.ConnectionInfo.PodmanPipe.Path}}"};
    private static final String[] PODMAN_SOCKET = new String[]{"podman", "info", "--format", "{{.Host.RemoteSocket.Path}}"};

    public static DockerClient getDockerClient() {
        return DockerClientUtils.getDockerClient(DockerClientUtils.probeContainerRuntime(null));
    }

    public static DockerClient getDockerClient(HostAndSocket runtimeInfo) {
        return DockerClientUtils.getDockerClient(runtimeInfo, (List<RegistryAuthConfig>)new ArrayList<RegistryAuthConfig>(){});
    }

    public static DockerClient getDockerClient(HostAndSocket runtimeInfo, List<RegistryAuthConfig> authConfigs) {
        if (runtimeInfo == null || runtimeInfo.host == null || runtimeInfo.host.isEmpty() || runtimeInfo.socket == null || runtimeInfo.socket.isEmpty()) {
            log.warn("Supplied host/socket was null, attempting to use auto-configured defaults");
            return DockerClientUtils.getDockerClient(DockerClientUtils.probeContainerRuntime(runtimeInfo), authConfigs);
        }
        log.debug("Using dockerhost " + runtimeInfo.host);
        DefaultDockerClientConfig config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(runtimeInfo.host).build();
        AuthDelegatingDockerClientConfig addcc = new AuthDelegatingDockerClientConfig((DockerClientConfig)config);
        addcc.setRegistryAuthConfigs(authConfigs);
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)addcc, (DockerHttpClient)httpClient);
        return dockerClient;
    }

    public static HostAndSocket probeContainerRuntime(HostAndSocket overrides) {
        if (overrides != null) {
            if (overrides.host != null && overrides.socket != null && !overrides.host.isEmpty() && !overrides.socket.isEmpty()) {
                return overrides;
            }
            if (overrides.host != null && overrides.host.isEmpty()) {
                overrides.host = null;
            }
            if (overrides.socket != null && overrides.socket.isEmpty()) {
                overrides.socket = null;
            }
        } else {
            overrides = new HostAndSocket(null, null);
        }
        try {
            Optional<String> dockerHost = Optional.ofNullable(overrides.host);
            if (!dockerHost.isPresent()) {
                dockerHost = Optional.ofNullable(System.getenv("DOCKER_HOST"));
            }
            Optional<String> dockerSocket = Optional.ofNullable(overrides.socket);
            if (dockerHost.isPresent() && !dockerSocket.isPresent() && ("unix:///var/run/podman/podman.sock".equals(dockerHost.get()) || "unix:///run/podman/podman.sock".equals(dockerHost.get()))) {
                return new HostAndSocket(dockerHost.get(), dockerHost.get().substring("unix://".length()));
            }
            log.info("Testing for podman/docker...");
            CmdResult cr = DockerClientUtils.start(PODMAN_SOCKET);
            if (cr.rc == 0) {
                log.info("Podman detected, configuring.");
                String socket = cr.output.get(0);
                if (socket.startsWith("unix://")) {
                    socket = socket.substring("unix://".length());
                }
                switch (OperatingSytem.getOperationSystem()) {
                    case WIN: {
                        CmdResult scmd = DockerClientUtils.start(WIN_PODMAN_HOST);
                        if (scmd.rc == 0) {
                            String fixedhost = scmd.output.get(0).replaceAll("\\", "/");
                            return new HostAndSocket(dockerHost.orElse(fixedhost), dockerSocket.orElse(cr.output.get(0)));
                        }
                        log.warn("Unable to obtain podman socket path from podman, using internal default");
                        return new HostAndSocket(dockerHost.orElse("npipe:////./pipe/docker_engine"), dockerSocket.orElse("/var/run/docker.sock"));
                    }
                    case LINUX: {
                        CmdResult scmd = DockerClientUtils.start(LIN_PODMAN_HOST);
                        if (scmd.rc == 0) {
                            return new HostAndSocket(dockerHost.orElse(scmd.output.get(0)), dockerSocket.orElse(socket));
                        }
                        log.warn("Unable to obtain podman socket path from podman, using internal default");
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/podman.sock"), dockerSocket.orElse("/var/run/podman.sock"));
                    }
                    case MAC: {
                        CmdResult scmd = DockerClientUtils.start(MAC_PODMAN_HOST);
                        if (scmd.rc == 0) {
                            return new HostAndSocket(dockerHost.orElse(scmd.output.get(0)), dockerSocket.orElse(socket));
                        }
                        log.warn("Unable to obtain podman socket path from podman, using internal default");
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/podman.sock"), dockerSocket.orElse("/var/run/podman.sock"));
                    }
                    case UNKNOWN: {
                        log.warn("Unable to identify Operating System, you may need to specify docker host / docker socket manually");
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/podman.sock"), dockerSocket.orElse("/var/run/podman.sock"));
                    }
                }
            } else {
                log.info("Assuming docker, configuring.");
                switch (OperatingSytem.getOperationSystem()) {
                    case WIN: {
                        return new HostAndSocket(dockerHost.orElse("npipe:////./pipe/docker_engine"), dockerSocket.orElse("/var/run/docker.sock"));
                    }
                    case LINUX: {
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/docker.sock"), dockerSocket.orElse("/var/run/docker.sock"));
                    }
                    case MAC: {
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/docker.sock"), dockerSocket.orElse("/var/run/docker.sock"));
                    }
                    case UNKNOWN: {
                        log.warn("Unable to identify Operating System, you may need to specify docker host / docker socket manually");
                        return new HostAndSocket(dockerHost.orElse("unix:///var/run/docker.sock"), dockerSocket.orElse("/var/run/docker.sock"));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error during Container Runtime Probe, verify podman/docker, or set Docker Host and Docker Socket explicitly", (Throwable)e);
        }
        log.error("Failed to determine docker host and docker socket path.");
        throw new IllegalStateException("Container Runtime detection failure");
    }

    private static CmdResult start(String[] cmd) {
        try {
            log.debug("Process start " + Arrays.toString(cmd));
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            List<String> output = null;
            try (InputStream stdo = p.getInputStream();){
                BufferedReader lineReader = new BufferedReader(new InputStreamReader(stdo));
                output = lineReader.lines().collect(Collectors.toList());
            }
            int rc = p.waitFor();
            log.debug("Process exit rc:" + rc + " response:" + output);
            return new CmdResult(rc, output);
        }
        catch (Exception e) {
            ArrayList<String> failReason = new ArrayList<String>();
            failReason.add("Process failed: ... ");
            for (StackTraceElement ste : e.getStackTrace()) {
                failReason.add(ste.toString());
            }
            return new CmdResult(255, failReason);
        }
    }

    public static class HostAndSocket {
        public String host;
        public String socket;

        public HostAndSocket(String host, String socket) {
            this.host = host;
            this.socket = socket;
        }

        public HostAndSocket(String host) {
            this.host = host;
            this.socket = null;
        }
    }

    private static class CmdResult {
        public final int rc;
        public final List<String> output;

        public CmdResult(int rc, List<String> out) {
            this.rc = rc;
            this.output = out;
        }
    }
}

