/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.Content;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;

public class StringContent
implements Content {
    private final String path;
    private final Integer mode;
    private final String content;

    public StringContent(String path, Integer mode, String content) {
        this.path = path;
        this.mode = mode;
        this.content = content;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public List<ContainerEntry> getContainerEntries() {
        return Arrays.asList(new ContainerEntry(){

            @Override
            public long getSize() {
                return StringContent.this.content.getBytes().length;
            }

            @Override
            public String getPath() {
                return StringContent.this.path;
            }

            @Override
            public Integer getMode() {
                return StringContent.this.mode;
            }

            @Override
            public ContainerEntry.DataSupplier getDataSupplier() {
                return () -> new ByteArrayInputStream(StringContent.this.content.getBytes());
            }
        });
    }
}

