/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Frame;
import dev.snowdrop.buildpack.ContainerLogReader;
import dev.snowdrop.buildpack.Slf4jLogger;
import dev.snowdrop.buildpack.docker.ContainerEntry;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.FileContent;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.docker.VolumeBind;
import dev.snowdrop.buildpack.utils.LifecycleArgs;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUtils {
    private static final Logger log = LoggerFactory.getLogger(VolumeUtils.class);
    static final String mountPrefix = "/workspace";

    public static boolean createVolumeIfRequired(DockerClient dc, String volumeName) {
        if (!VolumeUtils.exists(dc, volumeName)) {
            return VolumeUtils.internalCreateVolume(dc, volumeName);
        }
        return true;
    }

    public static boolean exists(DockerClient dc, String volumeName) {
        try {
            dc.inspectVolumeCmd(volumeName).exec();
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void removeVolume(DockerClient dc, String volumeName) {
        dc.removeVolumeCmd(volumeName).exec();
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String pathInVolume, File content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix, 0, 0, new FileContent(content).getContainerEntries());
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String name, Integer mode, String content) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix, 0, 0, new StringContent(name, mode, content).getContainerEntries());
    }

    public static boolean addContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, List<ContainerEntry> entries) {
        if (!prefix.isEmpty() && !prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, mountPrefix + prefix, uid, gid, entries);
    }

    private static boolean internalCreateVolume(DockerClient dc, String volumeName) {
        dc.createVolumeCmd().withName(volumeName).exec();
        return VolumeUtils.exists(dc, volumeName);
    }

    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, List<ContainerEntry> entries) {
        return VolumeUtils.internalAddContentToVolume(dc, volumeName, useImage, prefix, uid, gid, entries.toArray(new ContainerEntry[entries.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean internalAddContentToVolume(DockerClient dc, String volumeName, String useImage, String prefix, int uid, int gid, ContainerEntry ... entries) {
        LifecycleArgs args = new LifecycleArgs("/cnb/lifecycle/analyzer", null);
        args.addArg("-version");
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put("CNB_PLATFORM_API", "0.10");
        String dummyId = ContainerUtils.createContainer(dc, useImage, args.toList(), (Integer)uid, envMap, null, null, new VolumeBind(volumeName, mountPrefix));
        try {
            log.debug("Adding content to volume " + volumeName + " under prefix " + prefix + " using image " + useImage + " with volume bound at " + mountPrefix + " temp container id " + dummyId);
            log.trace("Starting container to ensure volume binds take effect correctly.");
            dc.startContainerCmd(dummyId).exec();
            log.trace("- Attaching log relay for volume copy container");
            ContainerLogReader slf4j = new ContainerLogReader(new Slf4jLogger(VolumeUtils.class));
            ContainerLogReader ignore = new ContainerLogReader(null){

                @Override
                public void onNext(Frame object) {
                }
            };
            ContainerLogReader logger = log.isDebugEnabled() ? slf4j : ignore;
            dc.logContainerCmd(dummyId).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(true)).exec((ResultCallback)logger);
            ContainerUtils.addContentToContainer(dc, dummyId, prefix, (Integer)uid, (Integer)gid, entries);
            try {
                slf4j.close();
                ignore.close();
            }
            catch (Exception e) {
                log.error("Error closing log relay ", (Throwable)e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (dummyId != null) {
                ContainerUtils.removeContainer(dc, dummyId);
            }
        }
    }
}

