/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle;

import dev.snowdrop.buildpack.BuildpackException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    String version;
    int major;
    int minor;
    final Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)(\\..*)?$");

    public Version(String v) {
        this.version = v;
        Matcher m = this.p.matcher(v);
        if (!m.find()) {
            throw new BuildpackException("Invalid format for Version " + v, new IllegalArgumentException());
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Version v) {
        return this.major == v.major && this.minor == v.minor;
    }

    public boolean greaterThan(Version v) {
        return this.major > v.major || this.major == v.major && this.minor > v.minor;
    }

    public boolean atLeast(Version v) {
        return this.major > v.major || this.major == v.major && this.minor >= v.minor;
    }

    public boolean atMost(Version v) {
        return this.major < v.major || this.major == v.major && this.minor <= v.minor;
    }

    public boolean lessThan(Version v) {
        return this.major < v.major || this.major == v.major && this.minor < v.minor;
    }

    public boolean equals(String ver) {
        return this.equals(new Version(ver));
    }

    public boolean greaterThan(String ver) {
        return this.greaterThan(new Version(ver));
    }

    public boolean atLeast(String ver) {
        return this.atLeast(new Version(ver));
    }

    public boolean atMost(String ver) {
        return this.atMost(new Version(ver));
    }

    public boolean lessThan(String ver) {
        return this.lessThan(new Version(ver));
    }
}

