/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle.phases;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import dev.snowdrop.buildpack.ContainerLogReader;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.lifecycle.ContainerStatus;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhase;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseAnalyzedTomlUpdater;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseFactory;
import dev.snowdrop.buildpack.utils.LifecycleArgs;
import org.slf4j.LoggerFactory;

public class Detector
implements LifecyclePhase,
LifecyclePhaseAnalyzedTomlUpdater {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Detector.class);
    private final LifecyclePhaseFactory factory;
    private byte[] analyzedToml = null;

    public Detector(LifecyclePhaseFactory factory) {
        this.factory = factory;
    }

    @Override
    public ContainerStatus runPhase(Logger logger, boolean useTimestamps) {
        LifecycleArgs args = new LifecycleArgs("/cnb/lifecycle/detector", null);
        args.addArg("-app", "/workspace");
        args.addArg("-analyzed", "/layers/analyzed.toml");
        args.addArg("-layers", "/layers");
        args.addArg("-platform", "/platform");
        args.addArg("-log-level", this.factory.getLogConfig().getLogLevel());
        if (this.factory.getPlatformLevel().atLeast("0.10") && this.factory.getBuilderImage().hasExtensions()) {
            args.addArg("-generated", "/layers/generated");
        }
        if (this.factory.getPlatformLevel().atLeast("0.12") && this.factory.getBuilderImage().hasExtensions()) {
            args.addArg("-run", "/cnb/run.toml");
        }
        int runAsId = this.factory.getBuilderImage().getUserId();
        String id = this.factory.getContainerForPhase(args.toArray(), runAsId);
        try {
            log.info("Detect container id " + id + " will be run with uid " + runAsId);
            log.debug("- container args " + args);
            log.info("- launching detect container");
            this.factory.getDockerConfig().getDockerClient().startContainerCmd(id).exec();
            log.info("- attaching log relay");
            this.factory.getDockerConfig().getDockerClient().logContainerCmd(id).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(useTimestamps)).exec((ResultCallback)new ContainerLogReader(logger));
            int rc = ((WaitContainerResultCallback)this.factory.getDockerConfig().getDockerClient().waitContainerCmd(id).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            log.info("Detect container complete, with exit code " + rc);
            this.analyzedToml = ContainerUtils.getFileFromContainer(this.factory.getDockerConfig().getDockerClient(), id, "/layers/analyzed.toml");
            return ContainerStatus.of(rc, id);
        }
        catch (Exception e) {
            if (id != null) {
                log.info("Exception during detect, removing container " + id);
                ContainerUtils.removeContainer(this.factory.getDockerConfig().getDockerClient(), id);
                log.info("remove complete");
            }
            throw e;
        }
    }

    @Override
    public byte[] getAnalyzedToml() {
        return this.analyzedToml;
    }

    @Override
    public void updateAnalyzedToml(String toml) {
        this.factory.addContentToLayersVolume(new StringContent("analyzed.toml", 511, toml));
    }
}

