/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack.lifecycle.phases;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import dev.snowdrop.buildpack.BuilderImage;
import dev.snowdrop.buildpack.ContainerLogReader;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.docker.ContainerUtils;
import dev.snowdrop.buildpack.docker.StringContent;
import dev.snowdrop.buildpack.lifecycle.ContainerStatus;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhase;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseAnalyzedTomlUpdater;
import dev.snowdrop.buildpack.lifecycle.LifecyclePhaseFactory;
import dev.snowdrop.buildpack.utils.LifecycleArgs;
import org.slf4j.LoggerFactory;

public class Restorer
implements LifecyclePhase,
LifecyclePhaseAnalyzedTomlUpdater {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Restorer.class);
    final LifecyclePhaseFactory factory;
    final BuilderImage originalBuilder;
    private byte[] analyzedToml = null;

    public Restorer(LifecyclePhaseFactory factory, BuilderImage originalBuilder) {
        this.factory = factory;
        this.originalBuilder = originalBuilder;
    }

    @Override
    public ContainerStatus runPhase(Logger logger, boolean useTimestamps) {
        LifecycleArgs args = new LifecycleArgs("/cnb/lifecycle/restorer", null);
        args.addArg("-uid", "" + this.factory.getBuilderImage().getUserId());
        args.addArg("-gid", "" + this.factory.getBuilderImage().getGroupId());
        args.addArg("-layers", "/layers");
        args.addArg("-cache-dir", "/cache-dir");
        args.addArg("-log-level", this.factory.getLogConfig().getLogLevel());
        if (this.factory.getPlatformLevel().atLeast("0.10") && this.factory.getBuilderImage().hasExtensions()) {
            args.addArg("-build-image", this.originalBuilder.getImage().getReferenceWithLatest());
        }
        int runAsId = this.factory.getBuilderImage().getUserId();
        if (this.factory.getPlatformLevel().atLeast("0.12") && this.factory.getDockerConfig().getUseDaemon().booleanValue()) {
            args.addArg("-daemon");
            runAsId = 0;
        }
        String id = this.factory.getContainerForPhase(args.toArray(), runAsId);
        try {
            log.info("Restorer container id " + id + " will be run with uid " + runAsId);
            log.debug("- container args " + args);
            log.info("- launching restorer container");
            this.factory.getDockerConfig().getDockerClient().startContainerCmd(id).exec();
            log.info("- attaching log relay");
            this.factory.getDockerConfig().getDockerClient().logContainerCmd(id).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withTimestamps(Boolean.valueOf(useTimestamps)).exec((ResultCallback)new ContainerLogReader(logger));
            int rc = ((WaitContainerResultCallback)this.factory.getDockerConfig().getDockerClient().waitContainerCmd(id).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            log.info("Restorer container complete, with exit code " + rc);
            this.analyzedToml = ContainerUtils.getFileFromContainer(this.factory.getDockerConfig().getDockerClient(), id, "/layers/analyzed.toml");
            return ContainerStatus.of(rc, id);
        }
        catch (Exception e) {
            if (id != null) {
                log.info("Exception during restorer, removing container " + id);
                ContainerUtils.removeContainer(this.factory.getDockerConfig().getDockerClient(), id);
                log.info("remove complete");
            }
            throw e;
        }
    }

    @Override
    public byte[] getAnalyzedToml() {
        return this.analyzedToml;
    }

    @Override
    public void updateAnalyzedToml(String toml) {
        this.factory.addContentToLayersVolume(new StringContent("analyzed.toml", 511, toml));
    }
}

