/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpClient;
import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpReceiver;
import dev.snowdrop.vertx.amqp.AmqpReceiverOptions;
import dev.snowdrop.vertx.amqp.AmqpSender;
import dev.snowdrop.vertx.amqp.AmqpSenderOptions;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpConnection;
import dev.snowdrop.vertx.amqp.SnowdropAmqpReceiver;
import dev.snowdrop.vertx.amqp.SnowdropAmqpSender;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import org.springframework.beans.factory.DisposableBean;
import reactor.core.publisher.Mono;

class SnowdropAmqpClient
implements AmqpClient,
DisposableBean {
    private final io.vertx.axle.amqp.AmqpClient delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpClient(io.vertx.axle.amqp.AmqpClient delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    @Override
    public Mono<AmqpConnection> connect() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.connect()).map(delegateConnection -> new SnowdropAmqpConnection((io.vertx.axle.amqp.AmqpConnection)delegateConnection, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createSender(String address) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createSender(address)).map(delegateSender -> new SnowdropAmqpSender((io.vertx.axle.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createSender(address, options.toVertxAmqpSenderOptions())).map(delegateSender -> new SnowdropAmqpSender((io.vertx.axle.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createReceiver(address)).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.axle.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions options) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createReceiver(address, options.toVertxAmqpReceiverOptions())).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.axle.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<Void> close() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.close());
    }

    public void destroy() {
        this.close().block(Duration.ofSeconds(10L));
    }
}

