/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpReceiver;
import dev.snowdrop.vertx.amqp.AmqpReceiverOptions;
import dev.snowdrop.vertx.amqp.AmqpSender;
import dev.snowdrop.vertx.amqp.AmqpSenderOptions;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpReceiver;
import dev.snowdrop.vertx.amqp.SnowdropAmqpSender;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

class SnowdropAmqpConnection
implements AmqpConnection {
    private final io.vertx.axle.amqp.AmqpConnection delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpConnection(io.vertx.axle.amqp.AmqpConnection delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    @Override
    public AmqpConnection exceptionHandler(Consumer<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public Mono<AmqpSender> createSender(String address) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createSender(address)).map(delegateSender -> new SnowdropAmqpSender((io.vertx.axle.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createSender(address, options.toVertxAmqpSenderOptions())).map(delegateSender -> new SnowdropAmqpSender((io.vertx.axle.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpSender> createAnonymousSender() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createAnonymousSender()).map(delegateSender -> new SnowdropAmqpSender((io.vertx.axle.amqp.AmqpSender)delegateSender, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createReceiver(address)).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.axle.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions options) {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createReceiver(address, options.toVertxAmqpReceiverOptions())).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.axle.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<AmqpReceiver> createDynamicReceiver() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.createDynamicReceiver()).map(delegateReceiver -> new SnowdropAmqpReceiver((io.vertx.axle.amqp.AmqpReceiver)delegateReceiver, this.messageConverter));
    }

    @Override
    public Mono<Void> close() {
        return Mono.fromCompletionStage((CompletionStage)this.delegate.close());
    }
}

