/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="vertx.amqp")
public class AmqpProperties {
    static final String PROPERTIES_PREFIX = "vertx.amqp";
    private boolean enabled = true;
    private String host = "localhost";
    private int port = 5672;
    private String username;
    private String password;
    private String containerId = UUID.randomUUID().toString();
    private Set<String> enabledSaslMechanisms = new LinkedHashSet<String>();
    private int heartbeat;
    private int maxFrameSize;
    private String virtualHost;
    private String sniServerName;
    private int reconnectAttempts;
    private long reconnectInterval = 1000L;
    private String hostnameVerificationAlgorithm = "";
    private int connectTimeout = 60000;
    private boolean trustAll;
    private String metricsName = "";
    private Proxy proxy = new Proxy();
    private String localAddress;
    private boolean tcpNoDelay = true;
    private boolean tcpKeepAlive;
    private int soLinger = -1;
    private boolean usePooledBuffers;
    private int idleTimeout;
    private TimeUnit idleTimeoutUnit = TimeUnit.SECONDS;
    private boolean ssl;
    private long sslHandshakeTimeout = 10L;
    private TimeUnit sslHandshakeTimeoutUnit = TimeUnit.SECONDS;
    private SslStore jksKeyStore = new SslStore();
    private SslStore jksTrustStore = new SslStore();
    private SslStore pfxKeyStore = new SslStore();
    private SslStore pfxTrustStore = new SslStore();
    private Set<String> enabledCipherSuites = new LinkedHashSet<String>();
    private JdkSslEngine jdkSslEngine = new JdkSslEngine();
    private OpenSslEngine openSslEngine = new OpenSslEngine();
    private Set<String> enabledSecureTransportProtocols = new LinkedHashSet<String>(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
    private boolean tcpFastOpen;
    private boolean tcpCork;
    private boolean tcpQuickAck;
    private int sendBufferSize = -1;
    private int receiveBufferSize = -1;
    private int trafficClass = -1;
    private boolean reuseAddress = true;
    private boolean logActivity;
    private boolean reusePort;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public Set<String> getEnabledSaslMechanisms() {
        return this.enabledSaslMechanisms;
    }

    public void setEnabledSaslMechanisms(Set<String> enabledSaslMechanisms) {
        this.enabledSaslMechanisms = enabledSaslMechanisms == null ? new LinkedHashSet<String>() : enabledSaslMechanisms;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getSniServerName() {
        return this.sniServerName;
    }

    public void setSniServerName(String sniServerName) {
        this.sniServerName = sniServerName;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public String getHostnameVerificationAlgorithm() {
        return this.hostnameVerificationAlgorithm;
    }

    public void setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isUsePooledBuffers() {
        return this.usePooledBuffers;
    }

    public void setUsePooledBuffers(boolean usePooledBuffers) {
        this.usePooledBuffers = usePooledBuffers;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public TimeUnit getIdleTimeoutUnit() {
        return this.idleTimeoutUnit;
    }

    public void setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        this.idleTimeoutUnit = idleTimeoutUnit;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public long getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public void setSslHandshakeTimeout(long sslHandshakeTimeout) {
        this.sslHandshakeTimeout = sslHandshakeTimeout;
    }

    public TimeUnit getSslHandshakeTimeoutUnit() {
        return this.sslHandshakeTimeoutUnit;
    }

    public void setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        this.sslHandshakeTimeoutUnit = sslHandshakeTimeoutUnit;
    }

    public SslStore getJksKeyStore() {
        return this.jksKeyStore;
    }

    public SslStore getJksTrustStore() {
        return this.jksTrustStore;
    }

    public SslStore getPfxKeyStore() {
        return this.pfxKeyStore;
    }

    public SslStore getPfxTrustStore() {
        return this.pfxTrustStore;
    }

    public Set<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(Set<String> enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites == null ? new LinkedHashSet<String>() : enabledCipherSuites;
    }

    public JdkSslEngine getJdkSslEngine() {
        return this.jdkSslEngine;
    }

    public OpenSslEngine getOpenSslEngine() {
        return this.openSslEngine;
    }

    public Set<String> getEnabledSecureTransportProtocols() {
        return this.enabledSecureTransportProtocols;
    }

    public void setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        this.enabledSecureTransportProtocols = enabledSecureTransportProtocols == null ? new LinkedHashSet<String>() : enabledSecureTransportProtocols;
    }

    public boolean isTcpFastOpen() {
        return this.tcpFastOpen;
    }

    public void setTcpFastOpen(boolean tcpFastOpen) {
        this.tcpFastOpen = tcpFastOpen;
    }

    public boolean isTcpCork() {
        return this.tcpCork;
    }

    public void setTcpCork(boolean tcpCork) {
        this.tcpCork = tcpCork;
    }

    public boolean isTcpQuickAck() {
        return this.tcpQuickAck;
    }

    public void setTcpQuickAck(boolean tcpQuickAck) {
        this.tcpQuickAck = tcpQuickAck;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isLogActivity() {
        return this.logActivity;
    }

    public void setLogActivity(boolean logActivity) {
        this.logActivity = logActivity;
    }

    public boolean isReusePort() {
        return this.reusePort;
    }

    public void setReusePort(boolean reusePort) {
        this.reusePort = reusePort;
    }

    public static enum ProxyType {
        HTTP,
        SOCKS4,
        SOCKS5;

    }

    public static class JdkSslEngine {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class OpenSslEngine {
        private boolean enabled;
        private boolean sessionCacheEnabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isSessionCacheEnabled() {
            return this.sessionCacheEnabled;
        }

        public void setSessionCacheEnabled(boolean sessionCacheEnabled) {
            this.sessionCacheEnabled = sessionCacheEnabled;
        }
    }

    public static class SslStore {
        private boolean enabled;
        private String password;
        private String path;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Proxy {
        private boolean enabled;
        private String host = "localhost";
        private int port = 3128;
        private String username;
        private String password;
        private ProxyType type = ProxyType.HTTP;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public ProxyType getType() {
            return this.type;
        }

        public void setType(ProxyType type) {
            this.type = type;
        }
    }
}

