/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpMessageBuilder;
import dev.snowdrop.vertx.amqp.SnowdropAmqpMessageBuilder;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.springframework.core.io.buffer.DataBuffer;

public interface AmqpMessage {
    public static AmqpMessageBuilder create() {
        return new SnowdropAmqpMessageBuilder();
    }

    public boolean isDurable();

    public boolean isFirstAcquirer();

    public int priority();

    public int deliveryCount();

    public long ttl();

    public String id();

    public String address();

    public String replyTo();

    public String correlationId();

    public boolean isBodyNull();

    public boolean bodyAsBoolean();

    public byte bodyAsByte();

    public short bodyAsShort();

    public int bodyAsInteger();

    public long bodyAsLong();

    public float bodyAsFloat();

    public double bodyAsDouble();

    public char bodyAsChar();

    public Instant bodyAsTimestamp();

    public UUID bodyAsUUID();

    public DataBuffer bodyAsBinary();

    public String bodyAsString();

    public String bodyAsSymbol();

    public <T> List<T> bodyAsList();

    public <K, V> Map<K, V> bodyAsMap();

    public JsonObject bodyAsJsonObject();

    public JsonArray bodyAsJsonArray();

    public String subject();

    public String contentType();

    public String contentEncoding();

    public long expiryTime();

    public long creationTime();

    public String groupId();

    public String replyToGroupId();

    public long groupSequence();

    public io.vertx.amqp.AmqpMessage toVertxAmqpMessage();
}

