/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.amqp;

import dev.snowdrop.vertx.amqp.AmqpConnection;
import dev.snowdrop.vertx.amqp.AmqpMessage;
import dev.snowdrop.vertx.amqp.AmqpReceiver;
import dev.snowdrop.vertx.amqp.MessageConverter;
import dev.snowdrop.vertx.amqp.SnowdropAmqpConnection;
import io.smallrye.mutiny.converters.multi.MultiReactorConverters;
import io.smallrye.mutiny.converters.uni.UniReactorConverters;
import io.vertx.core.streams.ReadStream;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class SnowdropAmqpReceiver
implements AmqpReceiver {
    private final io.vertx.mutiny.amqp.AmqpReceiver delegate;
    private final MessageConverter messageConverter;

    SnowdropAmqpReceiver(io.vertx.mutiny.amqp.AmqpReceiver delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    public Mono<AmqpMessage> mono() {
        return ((Mono)this.delegate.toMulti().convert().with((Function)MultiReactorConverters.toMono())).map(this.messageConverter::toSnowdropMessage);
    }

    public Flux<AmqpMessage> flux() {
        return ((Flux)this.delegate.toMulti().convert().with((Function)MultiReactorConverters.toFlux())).map(this.messageConverter::toSnowdropMessage);
    }

    @Override
    public String address() {
        return this.delegate.address();
    }

    @Override
    public AmqpConnection connection() {
        return new SnowdropAmqpConnection(this.delegate.connection(), this.messageConverter);
    }

    @Override
    public Mono<Void> close() {
        return (Mono)this.delegate.close().convert().with((Function)UniReactorConverters.toMono());
    }

    public ReadStream vertxReadStream() {
        return this.delegate.getDelegate();
    }
}

