/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server.properties;

import dev.snowdrop.vertx.http.server.properties.HttpServerOptionsCustomizer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.Ssl;

public class SslCustomizer
implements HttpServerOptionsCustomizer {
    private final AbstractConfigurableWebServerFactory factory;
    private final PropertyMapper propertyMapper;

    public SslCustomizer(AbstractConfigurableWebServerFactory factory) {
        this.factory = factory;
        this.propertyMapper = PropertyMapper.get();
    }

    @Override
    public HttpServerOptions apply(HttpServerOptions options) {
        Ssl ssl = this.factory.getSsl();
        if (ssl == null) {
            return options;
        }
        options.setSsl(ssl.isEnabled());
        options.setKeyCertOptions(this.keyCertOptionsAdapter(ssl));
        options.setTrustOptions(this.trustOptionsAdapter(ssl));
        this.propertyMapper.from((Object)ssl.getClientAuth()).whenNonNull().as(this::clientAuthAdapter).to(arg_0 -> ((HttpServerOptions)options).setClientAuth(arg_0));
        this.propertyMapper.from((Object)ssl.getEnabledProtocols()).whenNonNull().as(Arrays::asList).as(LinkedHashSet::new).to(arg_0 -> ((HttpServerOptions)options).setEnabledSecureTransportProtocols(arg_0));
        this.propertyMapper.from((Object)ssl.getCiphers()).whenNonNull().as(Arrays::stream).to(stream -> stream.forEach(arg_0 -> ((HttpServerOptions)options).addEnabledCipherSuite(arg_0)));
        return options;
    }

    private ClientAuth clientAuthAdapter(Ssl.ClientAuth clientAuth) {
        switch (clientAuth) {
            case WANT: {
                return ClientAuth.REQUEST;
            }
            case NEED: {
                return ClientAuth.REQUIRED;
            }
        }
        return ClientAuth.NONE;
    }

    private KeyCertOptions keyCertOptionsAdapter(Ssl ssl) {
        if ("JKS".equalsIgnoreCase(ssl.getKeyStoreType())) {
            return this.getJksOptions(ssl.getKeyStore(), ssl.getKeyStorePassword());
        }
        if ("PKCS12".equalsIgnoreCase(ssl.getKeyStoreType())) {
            return this.getPfxOptions(ssl.getKeyStore(), ssl.getKeyStorePassword());
        }
        return null;
    }

    private TrustOptions trustOptionsAdapter(Ssl ssl) {
        if ("JKS".equalsIgnoreCase(ssl.getTrustStoreType())) {
            return this.getJksOptions(ssl.getTrustStore(), ssl.getTrustStorePassword());
        }
        if ("PKCS12".equalsIgnoreCase(ssl.getTrustStoreType())) {
            return this.getPfxOptions(ssl.getTrustStore(), ssl.getTrustStorePassword());
        }
        return null;
    }

    private JksOptions getJksOptions(String path, String password) {
        JksOptions options = new JksOptions();
        options.setPath(path);
        options.setPassword(password);
        return options;
    }

    private PfxOptions getPfxOptions(String path, String password) {
        PfxOptions options = new PfxOptions();
        options.setPath(path);
        options.setPassword(password);
        return options;
    }
}

