/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.mail;

import dev.snowdrop.vertx.mail.EmailService;
import dev.snowdrop.vertx.mail.MailProperties;
import dev.snowdrop.vertx.mail.impl.EmailServiceImpl;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import io.vertx.axle.ext.mail.MailClient;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.LoginOption;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.StartTLSOptions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
@ConditionalOnBean(value={Vertx.class})
@ConditionalOnClass(value={MailClient.class})
@ConditionalOnProperty(prefix="vertx.mail", value={"enabled"}, matchIfMissing=true)
public class MailAutoConfiguration {
    @Bean
    public MailClient mailClient(Vertx vertx, MailProperties properties) {
        MailConfig config = new MailConfig();
        config.setAllowRcptErrors(properties.isAllowRcptErrors()).setDisableEsmtp(!properties.isEsmtp()).setHostname(properties.getHost()).setKeepAlive(properties.isKeepAlive()).setPort(properties.getPort()).setSsl(properties.isSsl()).setTrustAll(properties.isTrustAll());
        properties.getAuthMethods().ifPresent(arg_0 -> ((MailConfig)config).setAuthMethods(arg_0));
        properties.getKeystore().ifPresent(arg_0 -> ((MailConfig)config).setKeyStore(arg_0));
        properties.getKeystorePassword().ifPresent(arg_0 -> ((MailConfig)config).setKeyStorePassword(arg_0));
        properties.getLoginOption().ifPresent(s -> config.setLogin(LoginOption.valueOf((String)s.toUpperCase())));
        properties.getPassword().ifPresent(arg_0 -> ((MailConfig)config).setPassword(arg_0));
        properties.getStartTls().ifPresent(s -> config.setStarttls(StartTLSOptions.valueOf((String)s.toUpperCase())));
        properties.getUsername().ifPresent(arg_0 -> ((MailConfig)config).setUsername(arg_0));
        return MailClient.createNonShared((io.vertx.axle.core.Vertx)new io.vertx.axle.core.Vertx(vertx), (MailConfig)config);
    }

    @Bean
    public ReactiveTypeConverter<Mono> monoConverter() {
        return (ReactiveTypeConverter)Registry.lookup(Mono.class).orElseThrow(() -> new AssertionError((Object)"Mono converter was not found"));
    }

    @Bean
    public EmailService emailService(MailClient mailClient, ReactiveTypeConverter<Mono> monoConverter) {
        return new EmailServiceImpl(mailClient, monoConverter);
    }
}

