/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx;

import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.metrics.MetricsOptions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="vertx")
public class VertxProperties {
    static final String PROPERTIES_PREFIX = "vertx";
    private int eventLoopPoolSize = VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE;
    private int workerPoolSize = 20;
    private int internalBlockingPoolSize = 20;
    private long blockedThreadCheckInterval = VertxOptions.DEFAULT_BLOCKED_THREAD_CHECK_INTERVAL;
    private long maxEventLoopExecuteTime = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME;
    private long maxWorkerExecuteTime = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME;
    private boolean haEnabled = false;
    private int quorumSize = 1;
    private String haGroup = "__DEFAULT__";
    private long warningExceptionTime = TimeUnit.SECONDS.toNanos(5L);
    private boolean preferNativeTransport = false;
    private TimeUnit maxEventLoopExecuteTimeUnit = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT;
    private TimeUnit maxWorkerExecuteTimeUnit = VertxOptions.DEFAULT_MAX_WORKER_EXECUTE_TIME_UNIT;
    private TimeUnit warningExceptionTimeUnit = VertxOptions.DEFAULT_WARNING_EXCEPTION_TIME_UNIT;
    private TimeUnit blockedThreadCheckIntervalUnit = VertxOptions.DEFAULT_BLOCKED_THREAD_CHECK_INTERVAL_UNIT;
    private boolean metricsEnabled = false;
    private FileSystem fileSystem = new FileSystem();
    private AddressResolver addressResolver = new AddressResolver();

    public VertxOptions toVertxOptions() {
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setEventLoopPoolSize(this.eventLoopPoolSize);
        vertxOptions.setWorkerPoolSize(this.workerPoolSize);
        vertxOptions.setInternalBlockingPoolSize(this.internalBlockingPoolSize);
        vertxOptions.setBlockedThreadCheckInterval(this.blockedThreadCheckInterval);
        vertxOptions.setMaxEventLoopExecuteTime(this.maxEventLoopExecuteTime);
        vertxOptions.setMaxWorkerExecuteTime(this.maxWorkerExecuteTime);
        vertxOptions.setHAEnabled(this.haEnabled);
        vertxOptions.setQuorumSize(this.quorumSize);
        vertxOptions.setHAGroup(this.haGroup);
        vertxOptions.setWarningExceptionTime(this.warningExceptionTime);
        vertxOptions.setPreferNativeTransport(this.preferNativeTransport);
        vertxOptions.setMaxEventLoopExecuteTimeUnit(this.maxEventLoopExecuteTimeUnit);
        vertxOptions.setMaxWorkerExecuteTimeUnit(this.maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTimeUnit(this.warningExceptionTimeUnit);
        vertxOptions.setBlockedThreadCheckIntervalUnit(this.blockedThreadCheckIntervalUnit);
        MetricsOptions metricsOptions = new MetricsOptions();
        metricsOptions.setEnabled(this.metricsEnabled);
        vertxOptions.setMetricsOptions(metricsOptions);
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        fileSystemOptions.setClassPathResolvingEnabled(this.fileSystem.isClassPathResolvingEnabled());
        fileSystemOptions.setFileCachingEnabled(this.fileSystem.isFileCachingEnabled());
        vertxOptions.setFileSystemOptions(fileSystemOptions);
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        addressResolverOptions.setHostsPath(this.addressResolver.getHostsPath());
        addressResolverOptions.setHostsValue(this.addressResolver.getHostsValue());
        addressResolverOptions.setServers(this.addressResolver.getServers());
        addressResolverOptions.setOptResourceEnabled(this.addressResolver.isOptResourceEnabled());
        addressResolverOptions.setCacheMinTimeToLive(this.addressResolver.getCacheMinTimeToLive());
        addressResolverOptions.setCacheMaxTimeToLive(this.addressResolver.getCacheMaxTimeToLive());
        addressResolverOptions.setCacheNegativeTimeToLive(this.addressResolver.getCacheNegativeTimeToLive());
        addressResolverOptions.setQueryTimeout(this.addressResolver.getQueryTimeout());
        addressResolverOptions.setMaxQueries(this.addressResolver.getMaxQueries());
        addressResolverOptions.setRdFlag(this.addressResolver.isRdFlag());
        addressResolverOptions.setSearchDomains(this.addressResolver.getSearchDomains());
        addressResolverOptions.setNdots(this.addressResolver.getNdots());
        addressResolverOptions.setRotateServers(this.addressResolver.isRotateServers());
        vertxOptions.setAddressResolverOptions(addressResolverOptions);
        return vertxOptions;
    }

    public int getEventLoopPoolSize() {
        return this.eventLoopPoolSize;
    }

    public void setEventLoopPoolSize(int eventLoopPoolSize) {
        this.eventLoopPoolSize = eventLoopPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public int getInternalBlockingPoolSize() {
        return this.internalBlockingPoolSize;
    }

    public void setInternalBlockingPoolSize(int internalBlockingPoolSize) {
        this.internalBlockingPoolSize = internalBlockingPoolSize;
    }

    public long getBlockedThreadCheckInterval() {
        return this.blockedThreadCheckInterval;
    }

    public void setBlockedThreadCheckInterval(long blockedThreadCheckInterval) {
        this.blockedThreadCheckInterval = blockedThreadCheckInterval;
    }

    public long getMaxEventLoopExecuteTime() {
        return this.maxEventLoopExecuteTime;
    }

    public void setMaxEventLoopExecuteTime(long maxEventLoopExecuteTime) {
        this.maxEventLoopExecuteTime = maxEventLoopExecuteTime;
    }

    public long getMaxWorkerExecuteTime() {
        return this.maxWorkerExecuteTime;
    }

    public void setMaxWorkerExecuteTime(long maxWorkerExecuteTime) {
        this.maxWorkerExecuteTime = maxWorkerExecuteTime;
    }

    public boolean isHaEnabled() {
        return this.haEnabled;
    }

    public void setHaEnabled(boolean haEnabled) {
        this.haEnabled = haEnabled;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    public String getHaGroup() {
        return this.haGroup;
    }

    public void setHaGroup(String haGroup) {
        this.haGroup = haGroup;
    }

    public long getWarningExceptionTime() {
        return this.warningExceptionTime;
    }

    public void setWarningExceptionTime(long warningExceptionTime) {
        this.warningExceptionTime = warningExceptionTime;
    }

    public boolean isPreferNativeTransport() {
        return this.preferNativeTransport;
    }

    public void setPreferNativeTransport(boolean preferNativeTransport) {
        this.preferNativeTransport = preferNativeTransport;
    }

    public TimeUnit getMaxEventLoopExecuteTimeUnit() {
        return this.maxEventLoopExecuteTimeUnit;
    }

    public void setMaxEventLoopExecuteTimeUnit(TimeUnit maxEventLoopExecuteTimeUnit) {
        this.maxEventLoopExecuteTimeUnit = maxEventLoopExecuteTimeUnit;
    }

    public TimeUnit getMaxWorkerExecuteTimeUnit() {
        return this.maxWorkerExecuteTimeUnit;
    }

    public void setMaxWorkerExecuteTimeUnit(TimeUnit maxWorkerExecuteTimeUnit) {
        this.maxWorkerExecuteTimeUnit = maxWorkerExecuteTimeUnit;
    }

    public TimeUnit getWarningExceptionTimeUnit() {
        return this.warningExceptionTimeUnit;
    }

    public void setWarningExceptionTimeUnit(TimeUnit warningExceptionTimeUnit) {
        this.warningExceptionTimeUnit = warningExceptionTimeUnit;
    }

    public TimeUnit getBlockedThreadCheckIntervalUnit() {
        return this.blockedThreadCheckIntervalUnit;
    }

    public void setBlockedThreadCheckIntervalUnit(TimeUnit blockedThreadCheckIntervalUnit) {
        this.blockedThreadCheckIntervalUnit = blockedThreadCheckIntervalUnit;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public static class AddressResolver {
        private String hostsPath;
        private Buffer hostsValue;
        private List<String> servers = AddressResolverOptions.DEFAULT_SERVERS;
        private boolean optResourceEnabled = false;
        private int cacheMinTimeToLive = 0;
        private int cacheMaxTimeToLive = Integer.MAX_VALUE;
        private int cacheNegativeTimeToLive = 0;
        private long queryTimeout = 5000L;
        private int maxQueries = 4;
        private boolean rdFlag = true;
        private List<String> searchDomains = AddressResolverOptions.DEFAULT_SEACH_DOMAINS;
        private int ndots = AddressResolverOptions.DEFAULT_NDOTS;
        private boolean rotateServers = AddressResolverOptions.DEFAULT_ROTATE_SERVERS;

        public String getHostsPath() {
            return this.hostsPath;
        }

        public void setHostsPath(String hostsPath) {
            this.hostsPath = hostsPath;
        }

        public Buffer getHostsValue() {
            return this.hostsValue;
        }

        public void setHostsValue(Buffer hostsValue) {
            this.hostsValue = hostsValue;
        }

        public List<String> getServers() {
            return this.servers;
        }

        public void setServers(List<String> servers) {
            this.servers = servers;
        }

        public boolean isOptResourceEnabled() {
            return this.optResourceEnabled;
        }

        public void setOptResourceEnabled(boolean optResourceEnabled) {
            this.optResourceEnabled = optResourceEnabled;
        }

        public int getCacheMinTimeToLive() {
            return this.cacheMinTimeToLive;
        }

        public void setCacheMinTimeToLive(int cacheMinTimeToLive) {
            this.cacheMinTimeToLive = cacheMinTimeToLive;
        }

        public int getCacheMaxTimeToLive() {
            return this.cacheMaxTimeToLive;
        }

        public void setCacheMaxTimeToLive(int cacheMaxTimeToLive) {
            this.cacheMaxTimeToLive = cacheMaxTimeToLive;
        }

        public int getCacheNegativeTimeToLive() {
            return this.cacheNegativeTimeToLive;
        }

        public void setCacheNegativeTimeToLive(int cacheNegativeTimeToLive) {
            this.cacheNegativeTimeToLive = cacheNegativeTimeToLive;
        }

        public long getQueryTimeout() {
            return this.queryTimeout;
        }

        public void setQueryTimeout(long queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        public int getMaxQueries() {
            return this.maxQueries;
        }

        public void setMaxQueries(int maxQueries) {
            this.maxQueries = maxQueries;
        }

        public boolean isRdFlag() {
            return this.rdFlag;
        }

        public void setRdFlag(boolean rdFlag) {
            this.rdFlag = rdFlag;
        }

        public List<String> getSearchDomains() {
            return this.searchDomains;
        }

        public void setSearchDomains(List<String> searchDomains) {
            this.searchDomains = searchDomains;
        }

        public int getNdots() {
            return this.ndots;
        }

        public void setNdots(int ndots) {
            this.ndots = ndots;
        }

        public boolean isRotateServers() {
            return this.rotateServers;
        }

        public void setRotateServers(boolean rotateServers) {
            this.rotateServers = rotateServers;
        }
    }

    public static class FileSystem {
        private boolean classPathResolvingEnabled = FileSystemOptions.DEFAULT_CLASS_PATH_RESOLVING_ENABLED;
        private boolean fileCachingEnabled = FileSystemOptions.DEFAULT_FILE_CACHING_ENABLED;

        public boolean isClassPathResolvingEnabled() {
            return this.classPathResolvingEnabled;
        }

        public void setClassPathResolvingEnabled(boolean classPathResolvingEnabled) {
            this.classPathResolvingEnabled = classPathResolvingEnabled;
        }

        public boolean isFileCachingEnabled() {
            return this.fileCachingEnabled;
        }

        public void setFileCachingEnabled(boolean fileCachingEnabled) {
            this.fileCachingEnabled = fileCachingEnabled;
        }
    }
}

