/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.UIObject;

import eu.maydu.gwt.validation.client.i18n.StandardValidationMessages;


/**
 * Processes the validations failures from the server side and binds
 * them to the specific components on the client side. Invokes the
 * specified actions for the components that provided wrong data.
 * 
 * Has been deprecated in favor of the <code>processServerErrors</code> method
 * of <code>ValidationProcessor</code> class. 
 * 
 * @author Anatol Mayen
 *
 */
@Deprecated
public class ServerValidationProcessor {

	private boolean firstRun = true;
	@SuppressWarnings("unchecked")
	private Map<String,List<ValidationAction>> actionMap = new HashMap<String,List<ValidationAction>>();
	private Map<String, UIObject> uiMap = new HashMap<String, UIObject>();
	private Map<String, TextBoxBase> textMap = new HashMap<String, TextBoxBase>();
	private Map<String, ListBox> listMap = new HashMap<String, ListBox>();
	private StandardValidationMessages messages;
	
	public ServerValidationProcessor(StandardValidationMessages messages) {
		this.messages = messages;
	}
	
	
	
	@SuppressWarnings("unchecked")
	public void addBinding(UIObject object, String compName, ValidationAction... actions) {
		if(actions == null || actions.length < 1)
			return;
		List<ValidationAction> actionList = this.actionMap.get(compName);
		if(actionList == null)
			actionList = new LinkedList<ValidationAction>();
		for(ValidationAction action : actions) {
			if(!actionList.contains(action)) {
				actionList.add(action);
			}
		}
		this.actionMap.put(compName, actionList);
		uiMap.put(compName, object);
	}
	
	@SuppressWarnings("unchecked")
	public void addBinding(TextBoxBase object, String compName, ValidationAction... actions) {
		if(actions == null || actions.length < 1)
			return;
		List<ValidationAction> actionList = this.actionMap.get(compName);
		if(actionList == null)
			actionList = new LinkedList<ValidationAction>();
		for(ValidationAction action : actions) {
			if(!actionList.contains(action)) {
				actionList.add(action);
			}
		}
		this.actionMap.put(compName, actionList);
		textMap.put(compName, object);
	}
	
	@SuppressWarnings("unchecked")
	public void addBinding(ListBox object, String compName, ValidationAction... actions) {
		if(actions == null || actions.length < 1)
			return;
		List<ValidationAction> actionList = this.actionMap.get(compName);
		if(actionList == null)
			actionList = new LinkedList<ValidationAction>();
		for(ValidationAction action : actions) {
			if(!actionList.contains(action)) {
				actionList.add(action);
			}
		}
		this.actionMap.put(compName, actionList);
		listMap.put(compName, object);
	}
	
	
	
	public boolean processValidationErrors(ValidationException validationException) {
		if(!firstRun)
			reset();
		firstRun = false;
		if(validationException.getInvalidValues().isEmpty())
			return true;
		for(InvalidValueSerializable iv : validationException.getInvalidValues()) {
			String prop = iv.getPropertyName().trim();
			if(prop.indexOf(",") == -1)
				invokeActionForKey(iv.getMessage(),prop);
			else {
				String[] props = prop.split(",");
				for(String propName : props) {
					invokeActionForKey(iv.getMessage(), propName.trim());
				}
			}
		}
		
		return false;
	}
	
	@SuppressWarnings("unchecked")
	private void invokeActionForKey(String message, String propName) {
		if(!actionMap.containsKey(propName))
			return; // No validation actions supplied for this property
		List<ValidationAction> actions = actionMap.get(propName);
		
		ValidationResult result = new ValidationResult(message);
		if(uiMap.containsKey(propName)) {
			for(ValidationAction action : actions)
				action.invoke(result, uiMap.get(propName));
		}else if(textMap.containsKey(propName)) {
			for(ValidationAction action : actions)
				action.invoke(result, textMap.get(propName));
		}else if(listMap.containsKey(propName)) {
			for(ValidationAction action : actions)
				action.invoke(result, listMap.get(propName));
		}
	}
	
	@SuppressWarnings("unchecked")
	public void reset() {
		for(List<ValidationAction> actions : this.actionMap.values()) {
			if(actions != null) {
				for(ValidationAction action : actions) {
					action.reset();
				}
			}
		}
	}
	
}
