/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import com.google.gwt.user.client.ui.UIObject;


/**
 * The base class for all validation actions.
 * 
 * Normally it will be invoked by the Validator that it is
 * added to.
 * 
 * 
 * @author Anatol Gregory Mayen
 *
 * @param <O> The type of object that will be passed to the <code>ValidationAction</code>
 */
public abstract class ValidationAction<O> {
	
	/**
	 * This method will be invoked by the <code>Validator</code> this 
	 * action is added to.
	 * 
	 * @param result The validation result
	 * @param object An object, usually a widget
	 */
	public abstract void invoke(ValidationResult result, O object);
	
	
	/**
	 * Should be overridden by an action that needs to reset its state
	 * or changes that it may have made during a previous failed validation
	 * run. This method will only be called on a re-validation. So a first 
	 * validation run that is successful will not trigger this method, as well
	 * as a first validation run that is unsuccessful but no other validation
	 * try is done after that.   
	 */
	public void reset() {
	}
	
	
	/**
	 * Should be overridden by an action that needs to reset its state
	 * or changes that it may have made during a previous failed validation
	 * run. This method will only be called on a re-validation. So a first 
	 * validation run that is successful will not trigger this method, as well
	 * as a first validation run that is unsuccessful but no other validation
	 * try is done after that.
	 * 
	 * This method should be used by <code>MultiFieldValidators</code> to
	 * reset an action that was used on more than one <code>UIObject</code>.
	 * 
	 * So every action that wants to support MultiField validators should
	 * implement this method
	 * 
	 */
	public void reset(UIObject o) {
	}

}
