/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import java.util.LinkedList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;




/**
 *
 * This exception is used to communicate server side errors to
 * the client side. The rpc methods should declare to throw this
 * exception.
 * 
 * @author Anatol Mayen
 *
 */
public class ValidationException extends RuntimeException implements IsSerializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1809969609126016533L;
	private List<InvalidValueSerializable> invalidValues = new LinkedList<InvalidValueSerializable>();
	
	public ValidationException() {
		super();
	}
	
	public ValidationException(String msg) {
		super(msg);
	}
	
	public ValidationException(String message, List<InvalidValueSerializable> invalids) {
		super(message);
		this.invalidValues = invalids;
	}
	
	/**
	 * 
	 * @return The invalid values
	 */
	public List<InvalidValueSerializable> getInvalidValues() {
		return invalidValues;
	}
	
	//The invalidValues should not be set
	/*public void setInvalidValues(List<InvalidValueSerializable> values) {
		this.invalidValues = values;
	}*/
	
}
