/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.i18n;

/**
 * This interface should be used instead the <code>Message</code>
 * interface if you need to do lookup of a localized string via
 * a <code>String</code> key.
 * 
 * As usual you create an instance with GWT.create(your.class);
 * 
 * @author Anatol Mayen
 *
 */
public interface MessagesWithLookup {

	/**
	 * For dynamic lookup of the localizations.
	 * 
	 * The <code>key</code> argument must be the name of a method
	 * defined in the extending interface. 
	 * 
	 * @param key
	 * @param parameters
	 * @return
	 */
	public String getByKey(String key, Object... parameters);
	
}
