/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class GridPanel extends CellPanel {
	
	private int rowCount;
	//private int colCount;
	private int currentRow;
	private int currentCol;
	private Map<Integer,Integer> rowColCount;
	private List<LayoutData> layoutData;
	private boolean created = false;
	
	public GridPanel() {
		//super();
		this.rowCount = 0;
		//this.colCount = 0;
		this.currentRow = -1;
		this.currentCol = -1;
		this.layoutData = new LinkedList<LayoutData>();
		this.rowColCount = new HashMap<Integer, Integer>();
		
	}
	
	
	public GridPanel addRow() {
		if(created)
			throw new RuntimeException("GridPanel was already created");
		this.rowCount++;
		this.currentRow = this.rowCount-1;
		this.currentCol = 0;
		this.rowColCount.put(this.currentRow, 0);
		return this;
	}
	
	public GridPanel getRow(int row) {
		if(row > this.rowCount-1)
			throw new IllegalArgumentException("Requested row "+row+" does not exist. Maximum row is: "+(rowCount-1));
		this.currentRow = row;
		this.currentCol = this.rowColCount.get(row);
		return this;
	}
	
	public GridPanel addWidget(Widget widget, int rowspan, int colspan) {
		if(created)
			throw new RuntimeException("GridPanel was already created");
		if(this.currentRow == -1)
			addRow();
		layoutData.add(new LayoutData(widget, this.currentRow, this.currentCol, rowspan, colspan));
		this.rowColCount.put(this.currentRow, this.currentCol+colspan);
		
		return this;
	}
	
	public GridPanel addWidget(Widget widget) {
		if(created)
			throw new RuntimeException("GridPanel was already created");
		return addWidget(widget, 1, 1);
	}
	
	public GridPanel removeWidget(Widget widget) {
		if(created)
			throw new RuntimeException("GridPanel was already created");
		remove(widget);
		return this;
	}
	
	
	@Override
	public boolean remove(Widget widget) {
		if(created)
			throw new RuntimeException("GridPanel was already created");
		LayoutData token = new LayoutData(widget, 100, 100/*doesn't matter*/);
		int index = layoutData.indexOf(token);
		token = layoutData.get(index);
		//adjust colcount
		this.rowColCount.put(token.row, this.rowColCount.get(token.row)-token.colSpan);
		
		layoutData.remove(token);
		return super.remove(widget);
	}
	
	@Override
	public boolean remove(int index) {
		return false;
	}
	
	@Override
	public void clear() {
		layoutData.clear();
		super.clear();
	}
	
	public GridPanel create() {
		if(created )
			throw new RuntimeException("GridPanel already created. This panel implementation does not allow recreation.");
		Element tr, td;
		for(int row=0; row<this.rowCount; row++) {
			tr = DOM.createTR();
			for(LayoutData ld : this.layoutData) {
				if(ld.row != row)
					continue;
				td = DOM.createTD();
				if(ld.colSpan > 1)
					DOM.setElementPropertyInt(td, "colSpan", ld.colSpan);
				if(ld.rowSpan > 1)
					DOM.setElementPropertyInt(td, "rowSpan", ld.rowSpan);
				DOM.appendChild(tr, td);
				super.add(ld.widget, td);
			}
			DOM.appendChild(getBody(), tr);
		}
		
		this.created = true;
		return this;
	}
	



	private class LayoutData {
		public int rowSpan = 1, colSpan = 1;
		public int row = -1, col = -1;
		public Widget widget;
		
		public LayoutData(Widget w, int row, int col, int rowSpan, int colSpan) {
			if(rowSpan > 1)
				this.rowSpan = rowSpan;
			if(colSpan > 1)
				this.colSpan = colSpan;
			if(w == null)
				throw new IllegalArgumentException("Widget must not be null");
			if(row < 0)
				throw new IllegalArgumentException("Row must be 0 or greater");
			if(col < 0)
				throw new IllegalArgumentException("Col must be 0 or greater");
			this.widget = w;
			this.row = row;
			this.col = col;
		}
		
		public LayoutData(Widget w, int row, int col) {
			if(w == null)
				throw new IllegalArgumentException("Widget must not be null");
			if(row < 0)
				throw new IllegalArgumentException("Row must be 0 or greater");
			if(col < 0)
				throw new IllegalArgumentException("Col must be 0 or greater");
			this.widget = w;
			this.row = row;
			this.col = col;
		}
		
		@Override
		public boolean equals(Object o) {
			if(!(o instanceof LayoutData))
				return false;
			Widget w = ((LayoutData)o).widget;
			
			return this.widget.equals(w);
		}
		
		@Override
		public int hashCode() {
			return widget.hashCode();
		}
		
	}

}