/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase.panels;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

import eu.maydu.gwt.validation.client.DefaultValidationProcessor;
import eu.maydu.gwt.validation.client.ValidationProcessor;
import eu.maydu.gwt.validation.client.actions.FocusAction;
import eu.maydu.gwt.validation.client.actions.LabelTextAction;
import eu.maydu.gwt.validation.client.actions.StyleAction;
import eu.maydu.gwt.validation.client.description.PopupDescription;
import eu.maydu.gwt.validation.client.showcase.FormLayoutPanel;
import eu.maydu.gwt.validation.client.showcase.ShowcaseValidationConstants;
import eu.maydu.gwt.validation.client.showcase.ShowcaseValidationMessages;
import eu.maydu.gwt.validation.client.validators.multifield.MultiStringLengthValidator;
import eu.maydu.gwt.validation.client.validators.multifield.MultiStringsEqualsValidator;

public class MultiFieldValidators {
	
	
	private ValidationProcessor validator = new DefaultValidationProcessor();
	
	private PasswordTextBox pass1 = new PasswordTextBox();
	private PasswordTextBox pass2 = new PasswordTextBox();
	
	private TextBox name1 = new TextBox();
	private TextBox name2 = new TextBox();
	private TextBox name3 = new TextBox();
	
	private Label errorLabel = new Label();
	
	private ShowcaseValidationConstants constants = GWT.create(ShowcaseValidationConstants.class);
	
	public Panel getMultiFieldValidatorPanel() {
		
		VerticalPanel root = new VerticalPanel();
		
		FormLayoutPanel formPanel = new FormLayoutPanel();
		
		pass1.addFocusListener(new FocusListener() {


			public void onFocus(Widget sender) {
				// TODO Auto-generated method stub
				
			}


			public void onLostFocus(Widget sender) {
				validator.validate("passwords");
				
			}
		});
		
		pass2.addFocusListener(new FocusListener() {


			public void onFocus(Widget sender) {
				// TODO Auto-generated method stub
				
			}


			public void onLostFocus(Widget sender) {
				validator.validate("passwords");
				
			}
		});
		
		formPanel.add("Password 1", pass1, false)
		.add("Password 2", pass2, false)
		.newRow()
		.add("Name 1", name1, false)
		.add("Name 2", name2, false)
		.add("Name 3", name3, false)
		.newRow()
		.add("Password error", errorLabel, false)
		.create();
		
		FocusAction focusAction = new FocusAction();
		
		PopupDescription description = new PopupDescription(new ShowcaseValidationMessages());
		
		description.addDescription("password.description", pass1);
		description.addDescription("password.description", pass2);
		
		description.addDescription("multiEquals.description", name1);
		description.addDescription("multiEquals.description", name2);
		description.addDescription("multiEquals.description", name3);
		
		validator.addValidators("passwords", new MultiStringsEqualsValidator(pass1, pass2)
			.addActionForFailure(new StyleAction("validationFailedBorder"))
			/*.addActionForFailure(focusAction)*/.addActionForFailure(new LabelTextAction(errorLabel, false))
			, new MultiStringLengthValidator(6, 15, pass1, pass2)
			.addActionForFailure(new StyleAction("validationFailedBorder"))
			.addActionForFailure(new LabelTextAction(errorLabel, false))
			/*.addActionForFailure(focusAction)*/
		);
		
		
		validator.addValidators("names", new MultiStringsEqualsValidator(name1, name2, name3)
			.addActionForFailure(new StyleAction("validationFailedBorder"))
			.addActionForFailure(focusAction)
		);
		
		
		Button validate = new Button(constants.validate());
		validate.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				validator.validate();
			}
		});
		
		Button reset = new Button(constants.resetValidations());
		reset.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				validator.reset();
			}
		});
		
		HorizontalPanel buttonPanel = new HorizontalPanel();
		buttonPanel.add(reset);
		buttonPanel.add(validate);
		
		
		
		
		
		root.add(formPanel);
		root.add(buttonPanel);
		
		return root;
		
	}

}
