/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.transformers;

import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBoxBase;

import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.i18n.StandardValidationMessages;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class LowerCaseTransformer extends Validator<LowerCaseTransformer>{

	private TextBoxBase text;
	private SuggestBox suggest;

	
	public LowerCaseTransformer(TextBoxBase text) {
		super();
		this.setPreventsPropagationOfValidationChain(false);
		if(text == null)
			throw new IllegalArgumentException("text must not be null");
		this.text = text;
	}
	
	public LowerCaseTransformer(SuggestBox suggest) {
		super();
		this.setPreventsPropagationOfValidationChain(false);
		if(suggest == null)
			throw new IllegalArgumentException("suggest must not be null");
		this.suggest = suggest;
	}

	@Override
	public void invokeActions(ValidationResult result) {
		//No actions will be invoked by a Transformer
	}

	@Override
	public ValidationResult validate(ValidationMessages allMessages) {
		StandardValidationMessages messages = allMessages.getStandardMessages();
		uppercase();
		// No validation errors will occur on a transformer
		return null;
	}
	
	private void uppercase() {
		String value;
		if(text != null)
			value = text.getText();
		else value = suggest.getText();
		if(value == null)
			value = "";
		else value = value.toLowerCase();
		if(text != null)
			text.setText(value);
		else suggest.setText(value);
	}

}
