/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.validators;

import com.google.gwt.user.client.ui.ListBox;

import eu.maydu.gwt.validation.client.ValidationAction;
import eu.maydu.gwt.validation.client.ValidationResult;
import eu.maydu.gwt.validation.client.Validator;
import eu.maydu.gwt.validation.client.ValidationResult.ValidationError;
import eu.maydu.gwt.validation.client.i18n.StandardValidationMessages;
import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

/**
 * 
 * @author Anatol Mayen
 *
 */
public class ListBoxValidator extends Validator<ListBoxValidator>{
	
	private String unselectedValue;
	private ListBox box;
	
	public ListBoxValidator(ListBox box, String unselectedValue, boolean preventsPropagationOfValidationChain) {
		super();
		this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
		if(box == null)
			throw new IllegalArgumentException("box must not be null");
		if(unselectedValue == null)
			throw new IllegalArgumentException("unselectedValue must not be null");
		this.box = box;
		this.unselectedValue = unselectedValue;
	}
	
	public ListBoxValidator(ListBox box, String unselectedValue, boolean preventsPropagationOfValidationChain, String customMsgKey) {
		super();
		this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
		if(box == null)
			throw new IllegalArgumentException("box must not be null");
		if(unselectedValue == null)
			throw new IllegalArgumentException("unselectedValue must not be null");
		this.box = box;
		this.unselectedValue = unselectedValue;
		this.setCustomMsgKey(customMsgKey);
	}
	
	public ListBoxValidator(ListBox box, String unselectedValue) {
		super();
		this.setPreventsPropagationOfValidationChain(false);
		if(box == null)
			throw new IllegalArgumentException("box must not be null");
		if(unselectedValue == null)
			throw new IllegalArgumentException("unselectedValue must not be null");
		this.box = box;
		this.unselectedValue = unselectedValue;
	}
	
	public ListBoxValidator(ListBox box, String unselectedValue, String customMsgKey) {
		super();
		this.setPreventsPropagationOfValidationChain(false);
		if(box == null)
			throw new IllegalArgumentException("box must not be null");
		if(unselectedValue == null)
			throw new IllegalArgumentException("unselectedValue must not be null");
		this.box = box;
		this.unselectedValue = unselectedValue;
		this.setCustomMsgKey(customMsgKey);
	}
	
	public ListBoxValidator(ListBox box) {
		this(box, "-1", false);
	}

	
	public ListBoxValidator(ListBox box, boolean preventsPropagationOfValidationChain, String customMsgKey) {
		this(box, "-1", preventsPropagationOfValidationChain, customMsgKey);
	}

	@Override
	public void invokeActions(ValidationResult result) {
		for(ValidationAction action : getFailureActions()) {
			action.invoke(result, box);
		}
	}

	@Override
	public ValidationResult validate(ValidationMessages allMessages) {
		StandardValidationMessages messages = allMessages.getStandardMessages();
		int selectedIndex = box.getSelectedIndex();
		String selectedValue = this.unselectedValue;
		if(selectedIndex > -1)
			selectedValue = box.getValue(selectedIndex);
		if(selectedValue.equals(this.unselectedValue) && isRequired()) {
			
			ValidationResult result = new ValidationResult();
			ValidationError error = result.new ValidationError(null, getErrorMessage(allMessages, messages.mustSelectValue()));
			result.getErrors().add(error);
			return result;
		}
			
		return null;
	}
	
	
	

}
