/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.validators;

/**
 * Defines a class as an algorithm for a specific validation case.
 * Validator algorithms should try to only use functionality that is
 * available to both GWT code and non-GWT aware Java code so that
 * the same algorithm may be used to validate input on the client side
 * and on the server side.
 * 
 * @author Anatol Mayen
 *
 */
public interface ValidatorAlgorithm<T> {

	
	/**
	 * This method triggers the validation algorithm for the specified input.
	 * 
	 * @param input The input to validate
	 * @return The <code>ValidationAlgorithmResult</code> or <code>null</code> if the validation was successful
	 */
	public ValidatorAlgorithmResult validate(T input);
	
}
