/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.validators;

/**
 * Contains the error code and possibly some parameters of an invoked
 * <code>ValidationAlgorithm</code>.
 * 
 * @author Anatol Mayen
 *
 */
public class ValidatorAlgorithmResult {

	private int errorCode;
	private Object[] parameters;
	
	public ValidatorAlgorithmResult(int errorCode, Object... parameters) {
		this.errorCode = errorCode;
		this.parameters = parameters;
	}
	
	
	public int getErrorCode() {
		return errorCode;
	}
	
	public Object[] getParameters() {
		return parameters;
	}
	
	
	/**
	 * Convenience method that returns the first parameter casted to an <code>int</code>
	 * @return
	 */
	public int getIntParameter() {
		return Integer.valueOf(""+parameters[0]);
	}
	
	/**
	 * Convenience method that returns the first parameter casted to an <code>long</code>
	 * @return
	 */
	public long getLongParameter() {
		return Long.valueOf(""+parameters[0]);
	}
	
	/**
	 * Convenience method that returns the first parameter casted to an <code>float</code>
	 * @return
	 */
	public float getFloatParameter() {
		return Float.valueOf(""+parameters[0]);
	}
	
	/**
	 * Convenience method that returns the first parameter casted to an <code>double</code>
	 * @return
	 */
	public double getDoubleParameter() {
		return Double.valueOf(""+parameters[0]);
	}
	
	/**
	 * Convenience method that returns the first parameter casted to an <code>char</code>
	 * @return
	 */
	public char getCharParameter() {
		return (""+parameters[0]).charAt(0);
	}
	
}
