/*
 * Decompiled with CFR 0.152.
 */
package org.exteca.categorisation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exteca.categorisation.CategorisationException;
import org.exteca.categorisation.DefaultRules;
import org.exteca.categorisation.MarkupProcessor;
import org.exteca.categorisation.MetaData;
import org.exteca.categorisation.Parser;
import org.exteca.categorisation.RuleProcessor;
import org.exteca.language.Marker;
import org.exteca.language.Morpher;
import org.exteca.language.Tokeniser;
import org.exteca.ontology.Ontology;

public class CategorisationEngine {
    Tokeniser tokeniser = null;
    Parser parser = new Parser();
    MarkupProcessor markupProcessor = new MarkupProcessor();
    RuleProcessor ruleProcessor = new RuleProcessor();
    DefaultRules defaultRules = null;

    public void generateDefaultRules(DefaultRules defaultRules) throws CategorisationException {
        this.defaultRules = defaultRules;
    }

    public void load(Ontology ontology) throws CategorisationException {
        if (this.tokeniser == null) {
            throw new CategorisationException("No tokeniser supplied");
        }
        this.ruleProcessor.load(ontology, this.defaultRules, this.tokeniser);
    }

    public MetaData process(File file) throws CategorisationException {
        try {
            return this.process(new FileReader(file));
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    public MetaData process(InputStream inputStream) throws CategorisationException {
        try {
            return this.process(new BufferedReader(new InputStreamReader(inputStream)));
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    public MetaData process(String string) throws CategorisationException {
        try {
            return this.process(new FileReader(string));
        }
        catch (Exception exception) {
            throw new CategorisationException(exception);
        }
    }

    public MetaData process(Reader reader) throws CategorisationException {
        if (this.tokeniser == null) {
            throw new CategorisationException("No tokeniser supplied");
        }
        MetaData metaData = new MetaData();
        metaData.markups.putAll(this.ruleProcessor.markupPlaceholders);
        metaData.markups.clearSpans();
        this.parser.parse(reader, this.tokeniser, metaData.tokens, metaData.markups);
        this.markupProcessor.markup(metaData.tokens, metaData.markups);
        this.ruleProcessor.process(metaData.tokens, metaData.markups, metaData.conceptResults);
        return metaData;
    }

    public String explain() {
        return this.ruleProcessor.explain();
    }

    public String explain(String string) {
        return this.ruleProcessor.explain(string);
    }

    public void addMarker(Marker marker) {
        this.markupProcessor.addMarker(marker);
    }

    public void addMorpher(Morpher morpher) {
        this.ruleProcessor.morphemeProcessor.addMorpher(morpher);
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setTokeniser(Tokeniser tokeniser) {
        this.tokeniser = tokeniser;
    }

    public Tokeniser getTokeniser() {
        return this.tokeniser;
    }

    public MarkupProcessor getMarkupProcessor() {
        return this.markupProcessor;
    }

    public RuleProcessor getRuleProcessor() {
        return this.ruleProcessor;
    }
}

